/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG;
    public static final ForgeConfigSpec.BooleanValue ENABLED;
    public static final ForgeConfigSpec.BooleanValue STORM_MIXIN_ENABLED;
    public static final ForgeConfigSpec.IntValue STORM_PROXIMITY_CHECK_INTERVAL;
    public static final ForgeConfigSpec.IntValue STORM_PROXIMITY_CHECK_RADIUS;
    public static final ForgeConfigSpec.BooleanValue CUSTOM_MUSIC_ENABLED;
    public static final ForgeConfigSpec.IntValue MUSIC_MIN_DELAY;
    public static final ForgeConfigSpec.IntValue MUSIC_MAX_DELAY;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LOCATOR_WHITELIST;

    static {
        BUILDER.comment("General settings").push("general");
        ENABLED = BUILDER.comment("Enable the mod").define("enabled", true);
        BUILDER.pop();
        BUILDER.comment("Structure locator settings").push("locator");
        LOCATOR_WHITELIST = BUILDER.comment("List of whitelisted structure ids to detect/locate.").defineList("whitelist", List.of("minecraft:village_plains", "minecraft:mansion", "minecraft:stronghold", "minecraft:bastion_remnant"), o -> o instanceof String);
        BUILDER.pop();
        BUILDER.comment("Storm proximity check settings").push("storm_proximity_check");
        STORM_MIXIN_ENABLED = BUILDER.comment("Enable the mixin for storm proximity checks").define("mixin_enabled", true);
        STORM_PROXIMITY_CHECK_INTERVAL = BUILDER.comment("The interval in ticks between storm proximity checks").defineInRange("interval", 20, 1, Integer.MAX_VALUE);
        STORM_PROXIMITY_CHECK_RADIUS = BUILDER.comment("The radius in blocks around the player to check for storms").defineInRange("radius", 2048, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Music system settings").push("music");
        CUSTOM_MUSIC_ENABLED = BUILDER.comment("Enable the custom music system").define("enabled", true);
        MUSIC_MIN_DELAY = BUILDER.comment("Minimum delay in ticks between music tracks (1200 = 1 minute)").defineInRange("min_delay", 1200, 0, Integer.MAX_VALUE);
        MUSIC_MAX_DELAY = BUILDER.comment("Maximum additional random delay in ticks between music tracks").defineInRange("max_delay", 2400, 0, Integer.MAX_VALUE);
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

