/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client;

import java.awt.Color;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleRegistry;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;

@OnlyIn(value=Dist.CLIENT)
public class ClientParticleHandler {
    private static final ThreadLocal<RandomSource> RANDOM_THREAD_LOCAL = ThreadLocal.withInitial(RandomSource::m_216327_);

    private static RandomSource getRandom() {
        return RANDOM_THREAD_LOCAL.get();
    }

    public static void spawnRicochetSparkCone(Level level, double x, double y, double z, Vec3 coneDirection, float maxAngleRad, float speed, int count) {
        Vec3 normalizedConeDir = coneDirection.m_82541_();
        Vector3f coneDirJoml = new Vector3f((float)normalizedConeDir.f_82479_, (float)normalizedConeDir.f_82480_, (float)normalizedConeDir.f_82481_);
        for (int i = 0; i < count; ++i) {
            float angle = maxAngleRad * ClientParticleHandler.getRandom().m_188501_();
            Vector3f u = Math.abs(coneDirJoml.x) > Math.abs(coneDirJoml.z) ? new Vector3f(-coneDirJoml.y, coneDirJoml.x, 0.0f) : new Vector3f(0.0f, -coneDirJoml.z, coneDirJoml.y);
            u.normalize();
            Vector3f v = new Vector3f((Vector3fc)coneDirJoml).cross((Vector3fc)u);
            float randAzimuth = (float)(ClientParticleHandler.getRandom().m_188500_() * 2.0 * Math.PI);
            float sinAngle = (float)Math.sin(angle);
            float cosAngle = (float)Math.cos(angle);
            Vector3f pointOnConeBase = new Vector3f((Vector3fc)u).mul((float)Math.cos(randAzimuth) * sinAngle).add((Vector3fc)new Vector3f((Vector3fc)v).mul((float)Math.sin(randAzimuth) * sinAngle));
            Vector3f particleDir = new Vector3f((Vector3fc)coneDirJoml).mul(cosAngle).add((Vector3fc)pointOnConeBase);
            float particleSpeed = speed * (0.8f + ClientParticleHandler.getRandom().m_188501_() * 0.4f);
            double vx = particleDir.x * particleSpeed;
            double vy = particleDir.y * particleSpeed;
            double vz = particleDir.z * particleSpeed;
            WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SPARK_PARTICLE).setLifetime(() -> 8 + ClientParticleHandler.getRandom().m_188503_(9)).setGravityStrength(10.0f).setFrictionStrength(2.0f).setColorData(ColorParticleData.create((Color)new Color(255, 255, 205), (Color)new Color(81, 76, 24)).setCoefficient(1.5f).setEasing(Easing.QUAD_OUT).build()).setTransparencyData(GenericParticleData.create((float)1.0f, (float)0.0f).setCoefficient(1.2f).setEasing(Easing.QUAD_IN).build()).setScaleData(GenericParticleData.create((float)0.06f, (float)0.01f).setCoefficient(1.2f).setEasing(Easing.QUAD_OUT).build()).setBehavior((LodestoneBehaviorComponent)LodestoneBehaviorComponent.SPARK).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.ADDITIVE).setFullBrightLighting().enableNoClip().setMotion(vx, vy, vz).spawn(level, x, y - 0.2, z);
        }
    }

    public static void spawnSmoke(Level level, double x, double y, double z, Vec3 coneDirection, float maxAngleRad, float speed, int count) {
        if (level.f_46443_) {
            Vec3 normalizedConeDir = coneDirection.m_82541_();
            Vector3f coneDirJoml = new Vector3f((float)normalizedConeDir.f_82479_, (float)normalizedConeDir.f_82480_, (float)normalizedConeDir.f_82481_);
            for (int i = 0; i < count; ++i) {
                float angle = maxAngleRad * ClientParticleHandler.getRandom().m_188501_();
                Vector3f u = Math.abs(coneDirJoml.x) > Math.abs(coneDirJoml.z) ? new Vector3f(-coneDirJoml.y, coneDirJoml.x, 0.0f) : new Vector3f(0.0f, -coneDirJoml.z, coneDirJoml.y);
                u.normalize();
                Vector3f v = new Vector3f((Vector3fc)coneDirJoml).cross((Vector3fc)u);
                float randAzimuth = (float)(ClientParticleHandler.getRandom().m_188500_() * 2.0 * Math.PI);
                float sinAngle = (float)Math.sin(angle);
                float cosAngle = (float)Math.cos(angle);
                Vector3f pointOnConeBase = new Vector3f((Vector3fc)u).mul((float)Math.cos(randAzimuth) * sinAngle).add((Vector3fc)new Vector3f((Vector3fc)v).mul((float)Math.sin(randAzimuth) * sinAngle));
                Vector3f particleDir = new Vector3f((Vector3fc)coneDirJoml).mul(cosAngle).add((Vector3fc)pointOnConeBase);
                float particleSpeed = speed * (0.3f + ClientParticleHandler.getRandom().m_188501_() * 0.7f);
                double vx = particleDir.x * particleSpeed;
                double vy = particleDir.y * particleSpeed;
                double vz = particleDir.z * particleSpeed;
                WorldParticleBuilder.create((RegistryObject)LodestoneParticleRegistry.SMOKE_PARTICLE).setLifetime(() -> 10 + ClientParticleHandler.getRandom().m_188503_(20)).setGravityStrength(0.05f).setFrictionStrength(0.9f).setColorData(ColorParticleData.create((Color)new Color(200, 200, 200), (Color)new Color(100, 100, 100, 50)).setCoefficient(1.0f).setEasing(Easing.QUAD_OUT).build()).setTransparencyData(GenericParticleData.create((float)0.08f, (float)0.32f, (float)0.0f).build()).setSpinData(SpinParticleData.create((float)0.2f).build()).setScaleData(GenericParticleData.create((float)0.1f, (float)0.3f).setCoefficient(1.0f).setEasing(Easing.SINE_IN_OUT).build()).enableNoClip().setMotion(vx, vy, vz).spawn(level, x, y, z);
            }
        }
    }
}

