/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.card;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class CardInfoPanelText {
    private final Component text;
    private final int x;
    private final int y;
    private final int color;
    private final boolean dropShadow;
    private final int wrapWidth;
    private final float lineSpacing;
    private final int backgroundColor;
    private final boolean showBackground;
    private final int padding;

    public CardInfoPanelText(Component text, int x, int y, int color, boolean dropShadow, int wrapWidth, float lineSpacing) {
        this(text, x, y, color, dropShadow, wrapWidth, lineSpacing, 0, false, 5);
    }

    public CardInfoPanelText(Component text, int x, int y, int color, boolean dropShadow, int wrapWidth, float lineSpacing, int backgroundColor, boolean showBackground, int padding) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.color = color;
        this.dropShadow = dropShadow;
        this.wrapWidth = wrapWidth;
        this.lineSpacing = lineSpacing;
        this.backgroundColor = backgroundColor;
        this.showBackground = showBackground;
        this.padding = padding;
    }

    public void render(GuiGraphics gui) {
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        Font font = Minecraft.m_91087_().f_91062_;
        List lines = font.m_92923_((FormattedText)this.text, this.wrapWidth);
        if (this.showBackground && !lines.isEmpty()) {
            int n = lines.size();
            Objects.requireNonNull(font);
            int totalHeight = (int)((float)(n * 9) * this.lineSpacing);
            gui.m_280509_(this.x - this.padding, this.y - this.padding, this.x + this.wrapWidth + this.padding, this.y + totalHeight + this.padding, this.backgroundColor);
        }
        float yOffset = 0.0f;
        for (FormattedCharSequence line : lines) {
            gui.m_280649_(font, line, this.x, (int)((float)this.y + yOffset), this.color, this.dropShadow);
            Objects.requireNonNull(font);
            yOffset += 9.0f * this.lineSpacing;
        }
        poseStack.m_85849_();
    }
}

