/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.screen;

import com.radar.biohazardchanges.Config;
import com.radar.biohazardchanges.common.locate.StructureEnergyRegistry;
import com.radar.biohazardchanges.common.menu.ConsoleMenu;
import com.radar.biohazardchanges.common.network.C2SConsoleRefreshLinkPacket;
import com.radar.biohazardchanges.common.network.C2SConsoleSearchPacket;
import com.radar.biohazardchanges.common.network.C2SConsoleSetPreferencePacket;
import com.radar.biohazardchanges.common.network.NetworkHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ConsoleScreen
extends AbstractContainerScreen<ConsoleMenu> {
    private Button prevButton;
    private Button nextButton;
    private Button searchButton;
    private Button prefToggleButton;
    private Button refreshButton;
    private Button tabLocateButton;
    private Button tabTargetButton;
    private Button tabSignalsButton;
    private boolean toggleInFlight;
    private boolean lastSearching;
    private Tab selectedTab = Tab.LOCATE;
    private int candidatesScroll;

    public ConsoleScreen(ConsoleMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97726_ = 360;
        this.f_97727_ = 240;
    }

    private static BlockPos[] generateDecoyPositions(BlockPos center, BlockPos seedPos) {
        long seed = center.m_121878_() ^ seedPos.m_121878_();
        Random rand = new Random(seed);
        BlockPos[] out = new BlockPos[]{ConsoleScreen.radial(center, rand, 32, 96), ConsoleScreen.radial(center, rand, 128, 192), ConsoleScreen.radial(center, rand, 256, 384)};
        return out;
    }

    private static BlockPos radial(BlockPos center, Random rand, int min, int max) {
        double angle = rand.nextDouble() * Math.PI * 2.0;
        int dist = min + rand.nextInt(Math.max(1, max - min + 1));
        int dx = (int)Math.round(Math.cos(angle) * (double)dist);
        int dz = (int)Math.round(Math.sin(angle) * (double)dist);
        return center.m_7918_(dx, 0, dz);
    }

    public static ResourceLocation getWhitelistedStructureId(int index) {
        List list = (List)Config.LOCATOR_WHITELIST.get();
        if (list == null || list.isEmpty()) {
            return ResourceLocation.parse((String)"minecraft:mineshaft");
        }
        int i = Math.max(0, Math.min(index, list.size() - 1));
        String str = (String)list.get(i);
        ResourceLocation id = ResourceLocation.m_135820_((String)str);
        if (id == null) {
            id = ResourceLocation.parse((String)"minecraft:mineshaft");
        }
        return id;
    }

    private int drawWrapped(GuiGraphics gfx, Component text, int x, int y, int maxWidth, int color) {
        if (text == null) {
            return y;
        }
        gfx.m_280554_(this.f_96547_, (FormattedText)text, x, y, maxWidth, color);
        return y + this.f_96547_.m_239133_((FormattedText)text, maxWidth);
    }

    protected void m_7856_() {
        super.m_7856_();
        NetworkHandler.INSTANCE.sendToServer((Object)new C2SConsoleRefreshLinkPacket(((ConsoleMenu)this.f_97732_).getConsolePos()));
        this.toggleInFlight = false;
        this.lastSearching = ((ConsoleMenu)this.f_97732_).isSearching();
        this.candidatesScroll = 0;
        this.tabLocateButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Locate"), b -> {
            this.selectedTab = Tab.LOCATE;
            this.updateLocateControlsVisibility();
        }).m_252987_(this.f_97735_ + 12, this.f_97736_ + 12, 60, 20).m_253136_());
        this.tabTargetButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Targeting"), b -> {
            this.selectedTab = Tab.TARGETING;
            this.updateLocateControlsVisibility();
        }).m_252987_(this.f_97735_ + 76, this.f_97736_ + 12, 80, 20).m_253136_());
        this.tabSignalsButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Signals"), b -> {
            this.selectedTab = Tab.SIGNALS;
            this.updateLocateControlsVisibility();
        }).m_252987_(this.f_97735_ + 162, this.f_97736_ + 12, 64, 20).m_253136_());
        this.prevButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Prev"), b -> {
            List list = (List)Config.LOCATOR_WHITELIST.get();
            int size = list == null || list.isEmpty() ? 1 : list.size();
            int idx = ((ConsoleMenu)this.f_97732_).getSelectedIndex();
            ((ConsoleMenu)this.f_97732_).setSelectedIndex((idx - 1 + size) % size);
        }).m_252987_(this.f_97735_ + 12, this.f_97736_ + 40, 44, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Previous target"))).m_253136_());
        this.nextButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Next"), b -> {
            List list = (List)Config.LOCATOR_WHITELIST.get();
            int size = list == null || list.isEmpty() ? 1 : list.size();
            int idx = ((ConsoleMenu)this.f_97732_).getSelectedIndex();
            ((ConsoleMenu)this.f_97732_).setSelectedIndex((idx + 1) % size);
        }).m_252987_(this.f_97735_ + 60, this.f_97736_ + 40, 44, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Next target"))).m_253136_());
        this.searchButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.biohazardchanges.console.search"), b -> {
            ResourceLocation structId = ConsoleScreen.getWhitelistedStructureId(((ConsoleMenu)this.f_97732_).getSelectedIndex());
            StructureEnergyRegistry.EnergySpec spec = StructureEnergyRegistry.get(structId);
            C2SConsoleSearchPacket pkt = new C2SConsoleSearchPacket(((ConsoleMenu)this.f_97732_).getConsolePos(), structId, spec.defaultRadius(), ((ConsoleMenu)this.f_97732_).getSelectedIndex(), ((ConsoleMenu)this.f_97732_).getUnexploredPreference());
            NetworkHandler.INSTANCE.sendToServer((Object)pkt);
            this.toggleInFlight = true;
        }).m_252987_(this.f_97735_ + 108, this.f_97736_ + 40, 72, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Start or cancel a search"))).m_253136_());
        this.prefToggleButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Pref"), b -> {
            boolean next = !((ConsoleMenu)this.f_97732_).getUnexploredPreference();
            NetworkHandler.INSTANCE.sendToServer((Object)new C2SConsoleSetPreferencePacket(((ConsoleMenu)this.f_97732_).getConsolePos(), next));
        }).m_252987_(this.f_97735_ + 184, this.f_97736_ + 40, 72, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Toggle unexplored vs explored"))).m_253136_());
        this.refreshButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.biohazardchanges.console.refresh"), b -> NetworkHandler.INSTANCE.sendToServer((Object)new C2SConsoleRefreshLinkPacket(((ConsoleMenu)this.f_97732_).getConsolePos()))).m_252987_(this.f_97735_ + 12, this.f_97736_ + 66, 80, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Refresh link state"))).m_253136_());
        this.updateLocateControlsVisibility();
    }

    protected void m_7286_(GuiGraphics gfx, float partialTick, int mouseX, int mouseY) {
        int x = this.f_97735_;
        int y = this.f_97736_;
        int w = this.f_97726_;
        int h = this.f_97727_;
        gfx.m_280024_(x - 6, y - 6, x + w + 6, y + h + 6, -1609560048, -2146430960);
        gfx.m_280509_(x, y, x + w, y + h, -1089597938);
        gfx.m_280024_(x, y, x + w, y + 28, -14802136, -15328738);
        gfx.m_280509_(x, y + 28, x + w, y + 46, -1089597938);
    }

    protected void m_280003_(GuiGraphics gfx, int mouseX, int mouseY) {
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(gfx);
        super.m_88315_(gfx, mouseX, mouseY, partialTick);
        boolean antennaPowered = ((ConsoleMenu)this.f_97732_).isAntennaPowered();
        boolean consolePowered = ((ConsoleMenu)this.f_97732_).getEnergy() > 0;
        boolean searching = ((ConsoleMenu)this.f_97732_).isSearching();
        if (searching != this.lastSearching) {
            this.toggleInFlight = false;
            this.lastSearching = searching;
        }
        if (this.searchButton != null) {
            this.searchButton.m_93666_((Component)Component.m_237115_((String)(searching ? "gui.biohazardchanges.console.cancel" : "gui.biohazardchanges.console.search")));
            boolean bl = this.searchButton.f_93623_ = (searching || antennaPowered && consolePowered) && !this.toggleInFlight;
        }
        if (this.prefToggleButton != null) {
            this.prefToggleButton.m_93666_((Component)Component.m_237115_((String)(((ConsoleMenu)this.f_97732_).getUnexploredPreference() ? "gui.biohazardchanges.console.unexplored" : "gui.biohazardchanges.console.explored")));
            boolean bl = this.prefToggleButton.f_93623_ = !searching;
        }
        if (this.prevButton != null) {
            boolean bl = this.prevButton.f_93623_ = !searching;
        }
        if (this.nextButton != null) {
            this.nextButton.f_93623_ = !searching;
        }
        String title = Component.m_237115_((String)"gui.biohazardchanges.console").getString();
        int titleX = this.f_97735_ + (this.f_97726_ - this.f_96547_.m_92895_(title)) / 2;
        gfx.m_280056_(this.f_96547_, title, titleX, this.f_97736_ + 3, 0xFFFFFF, false);
        int panelW = 140;
        int panelH = 70;
        int px = this.f_97735_ + this.f_97726_ - panelW - 8;
        int py = this.f_97736_ + 68;
        int contentLeft = this.f_97735_ + 12;
        int contentRight = px - 8;
        int contentWidth = Math.max(40, contentRight - contentLeft);
        gfx.m_280509_(px - 1, py - 1, px + panelW + 1, py + panelH + 1, -14012618);
        gfx.m_280509_(px, py, px + panelW, py + panelH, -15657960);
        gfx.m_280056_(this.f_96547_, Component.m_237115_((String)"gui.biohazardchanges.console.power").getString(), px + 6, py + 4, 0xCCCCCC, false);
        gfx.m_280056_(this.f_96547_, Component.m_237115_((String)"gui.biohazardchanges.console.antenna").getString(), px + 6, py + 14, 0xAAAAAA, false);
        int abx = px + 6;
        int aby = py + 26;
        int abw = panelW - 12;
        int abh = 6;
        gfx.m_280509_(abx - 1, aby - 1, abx + abw + 1, aby + abh + 1, -14012618);
        gfx.m_280509_(abx, aby, abx + abw, aby + abh, -16118512);
        int maxA = Math.max(1, ((ConsoleMenu)this.f_97732_).getAntennaMaxEnergy());
        int curA = Math.max(0, Math.min(((ConsoleMenu)this.f_97732_).getAntennaEnergy(), maxA));
        int fillA = (int)Math.round((double)curA / (double)maxA * (double)abw);
        gfx.m_280509_(abx, aby, abx + fillA, aby + abh, antennaPowered ? -13726889 : -12303292);
        int pctA = (int)Math.round((double)curA / (double)maxA * 100.0);
        String ae = pctA + "%";
        int aeX = abx + abw - this.f_96547_.m_92895_(ae);
        gfx.m_280056_(this.f_96547_, ae, aeX, aby - 9, 0x88CCCC, false);
        gfx.m_280056_(this.f_96547_, Component.m_237115_((String)"gui.biohazardchanges.console.console").getString(), px + 6, py + 38, 0xAAAAAA, false);
        int cbx = px + 6;
        int cby = py + 50;
        int cbw = panelW - 12;
        int cbh = 6;
        gfx.m_280509_(cbx - 1, cby - 1, cbx + cbw + 1, cby + cbh + 1, -14012618);
        gfx.m_280509_(cbx, cby, cbx + cbw, cby + cbh, -16118512);
        int maxE = Math.max(1, ((ConsoleMenu)this.f_97732_).getMaxEnergy());
        int curE = Math.max(0, Math.min(((ConsoleMenu)this.f_97732_).getEnergy(), maxE));
        int fill = (int)Math.round((double)curE / (double)maxE * (double)cbw);
        gfx.m_280509_(cbx, cby, cbx + fill, cby + cbh, -13726889);
        int pctE = (int)Math.round((double)curE / (double)maxE * 100.0);
        String ce = pctE + "%";
        int ceX = cbx + cbw - this.f_96547_.m_92895_(ce);
        gfx.m_280056_(this.f_96547_, ce, ceX, cby - 9, 0x88CCCC, false);
        int cpx = px;
        int cpy = py + panelH + 6;
        int cpw = panelW;
        int cph = this.f_97736_ + this.f_97727_ - cpy - 8;
        if (this.selectedTab == Tab.LOCATE && cph > 28) {
            gfx.m_280509_(cpx - 1, cpy - 1, cpx + cpw + 1, cpy + cph + 1, -14012618);
            gfx.m_280509_(cpx, cpy, cpx + cpw, cpy + cph, -15657960);
            gfx.m_280056_(this.f_96547_, Component.m_237115_((String)"gui.biohazardchanges.console.candidates").getString(), cpx + 6, cpy + 4, 0xCCCCCC, false);
        }
        if (this.selectedTab == Tab.LOCATE) {
            int percentProgress = (int)Math.round((double)Math.max(0, Math.min(200, ((ConsoleMenu)this.f_97732_).getProgress())) / 200.0 * 100.0);
            gfx.m_280056_(this.f_96547_, Component.m_237110_((String)"gui.biohazardchanges.console.progress", (Object[])new Object[]{percentProgress + "%"}).getString(), this.f_97735_ + 12, this.f_97736_ + 98, 0xFFFFFF, false);
            int barX = this.f_97735_ + 12;
            int barY = this.f_97736_ + 112;
            int rightMargin = this.f_97735_ + this.f_97726_ - (px - 4);
            int barW = this.f_97726_ - 20 - rightMargin;
            int barH = 8;
            gfx.m_280509_(barX - 1, barY - 1, barX + barW + 1, barY + barH + 1, -14012618);
            gfx.m_280509_(barX, barY, barX + barW, barY + barH, -15657960);
            int pct = Math.max(0, Math.min(200, ((ConsoleMenu)this.f_97732_).getProgress()));
            int fillW = (int)Math.round((double)pct / 200.0 * (double)barW);
            int fillColor = -13726889;
            gfx.m_280509_(barX, barY, barX + fillW, barY + barH, fillColor);
            if (!consolePowered) {
                gfx.m_280056_(this.f_96547_, Component.m_237115_((String)"gui.biohazardchanges.console.no_console_power").getString(), this.f_97735_ + 12, this.f_97736_ + 128, 0xFF4444, false);
            } else if (antennaPowered) {
                ResourceLocation id = ConsoleScreen.getWhitelistedStructureId(((ConsoleMenu)this.f_97732_).getSelectedIndex());
                StructureEnergyRegistry.EnergySpec spec = StructureEnergyRegistry.get(id);
                gfx.m_280056_(this.f_96547_, Component.m_237110_((String)"gui.biohazardchanges.console.target", (Object[])new Object[]{id.toString()}).getString(), this.f_97735_ + 12, this.f_97736_ + 140, 0xFFFFFF, false);
                gfx.m_280056_(this.f_96547_, Component.m_237110_((String)"gui.biohazardchanges.console.start_cost", (Object[])new Object[]{String.valueOf(spec.startCost())}).getString(), this.f_97735_ + 12, this.f_97736_ + 154, 16753920, false);
                int totalRate = spec.sustainCostPerTick() + 10;
                gfx.m_280056_(this.f_96547_, Component.m_237110_((String)"gui.biohazardchanges.console.rate_total", (Object[])new Object[]{String.valueOf(totalRate)}).getString(), this.f_97735_ + 12, this.f_97736_ + 168, 16753920, false);
            } else {
                gfx.m_280056_(this.f_96547_, Component.m_237115_((String)"gui.biohazardchanges.console.no_antenna_power").getString(), this.f_97735_ + 12, this.f_97736_ + 128, 0xFF4444, false);
            }
            int fx = ((ConsoleMenu)this.f_97732_).getFoundX();
            int fy = ((ConsoleMenu)this.f_97732_).getFoundY();
            int fz = ((ConsoleMenu)this.f_97732_).getFoundZ();
            if (cph > 28) {
                int innerX = cpx + 6;
                int innerY = cpy + 18;
                int innerH = cph - 24;
                if (fx != Integer.MIN_VALUE) {
                    BlockPos found = new BlockPos(fx, fy, fz);
                    boolean explored = ((ConsoleMenu)this.f_97732_).wasLastFoundExplored();
                    int statusColor = explored ? 0xFF5555 : 0x55FF55;
                    String status = Component.m_237115_((String)(explored ? "gui.biohazardchanges.console.status_explored" : "gui.biohazardchanges.console.status_unexplored")).getString();
                    gfx.m_280056_(this.f_96547_, status, innerX, innerY, statusColor, false);
                    innerY += 12;
                    BlockPos[] decoys = ConsoleScreen.generateDecoyPositions(found, ((ConsoleMenu)this.f_97732_).getConsolePos());
                    ArrayList<BlockPos> list = new ArrayList<BlockPos>(List.of(decoys));
                    Collections.shuffle(list, new Random((found.m_121878_() ^ ((ConsoleMenu)this.f_97732_).getConsolePos().m_121878_()) * 31L));
                    int itemHeight = 12;
                    int visible = Math.max(0, innerH / itemHeight);
                    int total = list.size();
                    int maxScroll = Math.max(0, total - visible);
                    if (this.candidatesScroll > maxScroll) {
                        this.candidatesScroll = maxScroll;
                    }
                    int start = Math.max(0, Math.min(this.candidatesScroll, maxScroll));
                    for (int i = 0; i < visible && start + i < total; ++i) {
                        BlockPos p = (BlockPos)list.get(start + i);
                        int ly = innerY + i * itemHeight;
                        gfx.m_280056_(this.f_96547_, "- " + p.m_123341_() + "," + p.m_123342_() + "," + p.m_123343_(), innerX, ly, 0xCCCCCC, false);
                    }
                    if (maxScroll > 0) {
                        int sbW = 4;
                        int sbX = cpx + cpw - 2 - sbW;
                        int sbY = innerY;
                        int sbH = visible * itemHeight;
                        gfx.m_280509_(sbX, sbY, sbX + sbW, sbY + sbH, -14012618);
                        int knobH = Math.max(8, (int)Math.round((double)sbH * ((double)visible / (double)total)));
                        int knobY = sbY + (int)Math.round((double)(sbH - knobH) * ((double)start / (double)maxScroll));
                        gfx.m_280509_(sbX + 1, knobY, sbX + sbW - 1, knobY + knobH, -7829368);
                    }
                } else if (((ConsoleMenu)this.f_97732_).isSearching()) {
                    int dots = (int)(System.currentTimeMillis() / 400L % 4L);
                    String base = Component.m_237115_((String)"gui.biohazardchanges.console.locating").getString();
                    String anim = base + "".repeat(0);
                    anim = base + "...".substring(0, dots);
                    gfx.m_280056_(this.f_96547_, anim, innerX, innerY, 0x88CCCC, false);
                } else if (((ConsoleMenu)this.f_97732_).wasLocateFailed()) {
                    gfx.m_280056_(this.f_96547_, Component.m_237115_((String)"gui.biohazardchanges.console.error").getString(), innerX, innerY, 0xFF6666, false);
                } else {
                    gfx.m_280056_(this.f_96547_, Component.m_237115_((String)"gui.biohazardchanges.console.nothing").getString(), innerX, innerY, 0x888888, false);
                }
            }
        } else if (this.selectedTab == Tab.TARGETING) {
            int ty = this.f_97736_ + 110;
            ty = this.drawWrapped(gfx, (Component)Component.m_237113_((String)"Targeting module (coming soon)"), contentLeft, ty, contentWidth, 0xCCCCCC);
            ty = this.drawWrapped(gfx, (Component)Component.m_237113_((String)"- Input coordinates for devices like deathray"), contentLeft, ty + 6, contentWidth, 0x888888);
            this.drawWrapped(gfx, (Component)Component.m_237113_((String)"- Validate range/LOS and power requirements"), contentLeft, ty + 6, contentWidth, 0x888888);
        } else if (this.selectedTab == Tab.SIGNALS) {
            int sy = this.f_97736_ + 110;
            sy = this.drawWrapped(gfx, (Component)Component.m_237113_((String)"Signals module (coming soon)"), contentLeft, sy, contentWidth, 0xCCCCCC);
            sy = this.drawWrapped(gfx, (Component)Component.m_237113_((String)"- Send beacons or summon bosses via configured signals"), contentLeft, sy + 6, contentWidth, 0x888888);
            this.drawWrapped(gfx, (Component)Component.m_237113_((String)"- Permission checks and cooldowns will apply"), contentLeft, sy + 6, contentWidth, 0x888888);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int panelW = 140;
        int panelH = 70;
        int px = this.f_97735_ + this.f_97726_ - panelW - 8;
        int py = this.f_97736_ + 68;
        int cpx = px;
        int cpy = py + panelH + 8;
        int cpw = panelW;
        int cph = this.f_97736_ + this.f_97727_ - cpy - 8;
        int fx = ((ConsoleMenu)this.f_97732_).getFoundX();
        int fy = ((ConsoleMenu)this.f_97732_).getFoundY();
        int fz = ((ConsoleMenu)this.f_97732_).getFoundZ();
        if (cph > 28 && fx != Integer.MIN_VALUE && mouseX >= (double)cpx && mouseX <= (double)(cpx + cpw) && mouseY >= (double)cpy && mouseY <= (double)(cpy + cph)) {
            BlockPos found = new BlockPos(fx, fy, fz);
            BlockPos[] decoys = ConsoleScreen.generateDecoyPositions(found, ((ConsoleMenu)this.f_97732_).getConsolePos());
            ArrayList<BlockPos> list = new ArrayList<BlockPos>(List.of(decoys));
            Collections.shuffle(list, new Random((found.m_121878_() ^ ((ConsoleMenu)this.f_97732_).getConsolePos().m_121878_()) * 31L));
            int itemHeight = 12;
            int innerH = cph - 24 - 12;
            int visible = Math.max(1, innerH / itemHeight);
            int total = list.size();
            int maxScroll = Math.max(0, total - visible);
            if (maxScroll > 0) {
                int step = delta > 0.0 ? -1 : 1;
                this.candidatesScroll = Math.max(0, Math.min(this.candidatesScroll + step, maxScroll));
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void updateLocateControlsVisibility() {
        boolean locate;
        boolean bl = locate = this.selectedTab == Tab.LOCATE;
        if (this.prevButton != null) {
            this.prevButton.f_93624_ = locate;
        }
        if (this.nextButton != null) {
            this.nextButton.f_93624_ = locate;
        }
        if (this.searchButton != null) {
            this.searchButton.f_93624_ = locate;
        }
        if (this.prefToggleButton != null) {
            this.prefToggleButton.f_93624_ = locate;
        }
        if (this.refreshButton != null) {
            this.refreshButton.f_93624_ = locate;
        }
    }

    private static enum Tab {
        LOCATE,
        TARGETING,
        SIGNALS;

    }
}

