/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.vfx.handler;

import com.radar.biohazardchanges.client.vfx.base.EffectTrack;
import com.radar.biohazardchanges.client.vfx.base.clips.EffectClip;
import com.radar.biohazardchanges.client.vfx.base.clips.FloatClip;
import com.radar.biohazardchanges.client.vfx.handler.IEffectTrackHandler;
import com.radar.biohazardchanges.client.vfx.playback.TimelineInstance;
import java.util.HashMap;

public class FloatTrackHandler
implements IEffectTrackHandler {
    @Override
    public void handle(TimelineInstance instance, EffectTrack track) {
        HashMap<String, FloatClip> activeClips = new HashMap<String, FloatClip>();
        for (EffectClip clipUntyped : track.getClips()) {
            FloatClip clip;
            if (!(clipUntyped instanceof FloatClip) || !(clip = (FloatClip)clipUntyped).isActive(instance.getAge())) continue;
            activeClips.put(clip.name, clip);
        }
        for (FloatClip clip : activeClips.values()) {
            float elapsedTime = instance.getAge() - clip.getStartTime();
            float changeInValue = clip.toValue - clip.fromValue;
            float value = clip.easing.ease(elapsedTime, clip.fromValue, changeInValue, (float)clip.getDuration());
            instance.setFloatValue(clip.name, value);
        }
    }
}

