/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.vfx.particles;

import com.radar.biohazardchanges.client.vfx.particles.IParticleSpawner;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleSpawners {

    public static class Point
    implements IParticleSpawner {
        @Override
        public Vec3 getPosition(Level level, Vec3 center) {
            return center;
        }
    }

    public static class Box
    implements IParticleSpawner {
        private final double width;
        private final double height;
        private final double depth;
        private final RandomSource random = RandomSource.m_216327_();

        public Box(double width, double height, double depth) {
            this.width = width;
            this.height = height;
            this.depth = depth;
        }

        @Override
        public Vec3 getPosition(Level level, Vec3 center) {
            double x = center.m_7096_() + (this.random.m_188500_() - 0.5) * this.width;
            double y = center.m_7098_() + (this.random.m_188500_() - 0.5) * this.height;
            double z = center.m_7094_() + (this.random.m_188500_() - 0.5) * this.depth;
            return new Vec3(x, y, z);
        }
    }

    public static class Sphere
    implements IParticleSpawner {
        private final double radius;
        private final RandomSource random = RandomSource.m_216327_();

        public Sphere(double radius) {
            this.radius = radius;
        }

        @Override
        public Vec3 getPosition(Level level, Vec3 center) {
            double theta = this.random.m_188500_() * Math.PI * 2.0;
            double phi = this.random.m_188500_() * Math.PI;
            double x = center.m_7096_() + this.radius * Math.sin(phi) * Math.cos(theta);
            double y = center.m_7098_() + this.radius * Math.sin(phi) * Math.sin(theta);
            double z = center.m_7094_() + this.radius * Math.cos(phi);
            return new Vec3(x, y, z);
        }
    }

    public static class Cylinder
    implements IParticleSpawner {
        private final double radius;
        private final double height;
        private final boolean onEdge;
        private final RandomSource random = RandomSource.m_216327_();

        public Cylinder(double radius, double height, boolean onEdge) {
            this.radius = radius;
            this.height = height;
            this.onEdge = onEdge;
        }

        @Override
        public Vec3 getPosition(Level level, Vec3 center) {
            double angle = this.random.m_188500_() * 2.0 * Math.PI;
            double currentRadius = this.onEdge ? this.radius : this.random.m_188500_() * this.radius;
            double x = center.m_7096_() + Math.cos(angle) * currentRadius;
            double y = center.m_7098_() + this.random.m_188500_() * this.height - this.height / 2.0;
            double z = center.m_7094_() + Math.sin(angle) * currentRadius;
            return new Vec3(x, y, z);
        }
    }
}

