/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.vfx.particles.patterns;

import com.radar.biohazardchanges.client.vfx.particles.patterns.ISpawnPattern;
import com.radar.biohazardchanges.client.vfx.playback.TimelineInstance;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpherePattern
implements ISpawnPattern {
    private final float radius;
    private final int particleCount;

    public SpherePattern(float radius, int particleCount) {
        this.radius = radius;
        this.particleCount = particleCount;
    }

    @Override
    public Collection<Vec3> getPositions(TimelineInstance instance) {
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        RandomSource random = instance.getLevel().f_46441_;
        for (int i = 0; i < this.particleCount; ++i) {
            double theta = Math.PI * 2 * random.m_188500_();
            double phi = Math.acos(1.0 - 2.0 * random.m_188500_());
            double x = (double)this.radius * Math.sin(phi) * Math.cos(theta);
            double y = (double)this.radius * Math.sin(phi) * Math.sin(theta);
            double z = (double)this.radius * Math.cos(phi);
            positions.add(new Vec3(x, y, z));
        }
        return positions;
    }
}

