/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.vfx.playback;

import com.radar.biohazardchanges.client.vfx.base.EffectTimeline;
import com.radar.biohazardchanges.client.vfx.base.EffectTrack;
import com.radar.biohazardchanges.client.vfx.base.tracks.ControlTrack;
import com.radar.biohazardchanges.client.vfx.base.tracks.EventTrack;
import com.radar.biohazardchanges.client.vfx.base.tracks.FloatTrack;
import com.radar.biohazardchanges.client.vfx.base.tracks.ParticleTrack;
import com.radar.biohazardchanges.client.vfx.base.tracks.PositionTrack;
import com.radar.biohazardchanges.client.vfx.base.tracks.ScreenshakeTrack;
import com.radar.biohazardchanges.client.vfx.base.tracks.SoundTrack;
import com.radar.biohazardchanges.client.vfx.base.tracks.UniformTrack;
import com.radar.biohazardchanges.client.vfx.handler.ControlTrackHandler;
import com.radar.biohazardchanges.client.vfx.handler.EventTrackHandler;
import com.radar.biohazardchanges.client.vfx.handler.FloatTrackHandler;
import com.radar.biohazardchanges.client.vfx.handler.IEffectTrackHandler;
import com.radar.biohazardchanges.client.vfx.handler.ParticleTrackHandler;
import com.radar.biohazardchanges.client.vfx.handler.PositionTrackHandler;
import com.radar.biohazardchanges.client.vfx.handler.ScreenshakeTrackHandler;
import com.radar.biohazardchanges.client.vfx.handler.SoundTrackHandler;
import com.radar.biohazardchanges.client.vfx.handler.UniformTrackHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TimelineInstance {
    private static final Map<Class<? extends EffectTrack>, IEffectTrackHandler> HANDLERS = new HashMap<Class<? extends EffectTrack>, IEffectTrackHandler>();
    private final UUID id = UUID.randomUUID();
    private final EffectTimeline timeline;
    private final Level level;
    private final Vec3 initialPosition;
    private final Map<String, Float> uniformValues = new HashMap<String, Float>();
    private final Map<String, Float> floatValues = new HashMap<String, Float>();
    private Vec3 position;
    private int age = 0;
    private boolean paused = false;
    private Vec3 positionOffset = Vec3.f_82478_;

    public TimelineInstance(EffectTimeline timeline, Level level, Vec3 position) {
        this.timeline = timeline;
        this.level = level;
        this.position = position;
        this.initialPosition = position;
    }

    public void tick() {
        if (this.paused) {
            return;
        }
        this.floatValues.clear();
        this.uniformValues.clear();
        this.positionOffset = Vec3.f_82478_;
        for (EffectTrack track : this.timeline.tracks()) {
            IEffectTrackHandler handler = HANDLERS.get(track.getClass());
            if (handler == null) continue;
            handler.handle(this, track);
        }
        this.position = this.initialPosition.m_82549_(this.positionOffset);
        ++this.age;
    }

    public void pause() {
        this.paused = true;
    }

    public void unpause() {
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public float getUniformValue(String name) {
        return this.uniformValues.getOrDefault(name, Float.valueOf(0.0f)).floatValue();
    }

    public void setUniformValue(String name, float value) {
        this.uniformValues.put(name, Float.valueOf(value));
    }

    public float getFloatValue(String name) {
        return this.floatValues.getOrDefault(name, Float.valueOf(0.0f)).floatValue();
    }

    public void setFloatValue(String name, float value) {
        this.floatValues.put(name, Float.valueOf(value));
    }

    public UUID getId() {
        return this.id;
    }

    public Level getLevel() {
        return this.level;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public void setPosition(Vec3 position) {
        this.position = position;
    }

    public Vec3 getPositionOffset() {
        return this.positionOffset;
    }

    public void setPositionOffset(Vec3 positionOffset) {
        this.positionOffset = positionOffset;
    }

    public int getAge() {
        return this.age;
    }

    public boolean isFinished() {
        return this.age > this.timeline.duration();
    }

    static {
        HANDLERS.put(ParticleTrack.class, new ParticleTrackHandler());
        HANDLERS.put(SoundTrack.class, new SoundTrackHandler());
        HANDLERS.put(ScreenshakeTrack.class, new ScreenshakeTrackHandler());
        HANDLERS.put(UniformTrack.class, new UniformTrackHandler());
        HANDLERS.put(ControlTrack.class, new ControlTrackHandler());
        HANDLERS.put(FloatTrack.class, new FloatTrackHandler());
        HANDLERS.put(EventTrack.class, new EventTrackHandler());
        HANDLERS.put(PositionTrack.class, new PositionTrackHandler());
    }
}

