/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.ballistics;

import net.minecraft.world.phys.Vec3;

public class BallisticOutcome {
    public final Type type;
    public final Vec3 outgoingDirection;
    public final double outgoingSpeedMultiplier;
    public final int spallCount;
    public final float spallConeAngleRad;

    private BallisticOutcome(Type type, Vec3 outgoingDirection, double outgoingSpeedMultiplier, int spallCount, float spallConeAngleRad) {
        this.type = type;
        this.outgoingDirection = outgoingDirection;
        this.outgoingSpeedMultiplier = outgoingSpeedMultiplier;
        this.spallCount = spallCount;
        this.spallConeAngleRad = spallConeAngleRad;
    }

    public static BallisticOutcome deflect(Vec3 dir, double speedMul) {
        return new BallisticOutcome(Type.DEFLECT, dir, speedMul, 0, 0.0f);
    }

    public static BallisticOutcome ricochet(Vec3 dir, double speedMul) {
        return new BallisticOutcome(Type.RICOCHET, dir, speedMul, 0, 0.0f);
    }

    public static BallisticOutcome penetrate() {
        return new BallisticOutcome(Type.PENETRATE, null, 1.0, 0, 0.0f);
    }

    public static BallisticOutcome spall(int count, float coneAngleRad) {
        return new BallisticOutcome(Type.SPALL, null, 0.0, count, coneAngleRad);
    }

    public static BallisticOutcome none() {
        return new BallisticOutcome(Type.NONE, null, 1.0, 0, 0.0f);
    }

    public static enum Type {
        NONE,
        DEFLECT,
        RICOCHET,
        PENETRATE,
        SPALL;

    }
}

