/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.ballistics;

import com.radar.biohazardchanges.common.ballistics.BallisticOutcome;
import com.radar.biohazardchanges.common.ballistics.DeflectionProfile;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public final class BallisticsResolver {
    private BallisticsResolver() {
    }

    public static BallisticOutcome resolve(RandomSource rng, Vec3 incomingDirUnit, Vec3 surfaceNormalUnit, DeflectionProfile profile) {
        Vec3 reflection = incomingDirUnit.m_82546_(surfaceNormalUnit.m_82490_(2.0 * incomingDirUnit.m_82526_(surfaceNormalUnit))).m_82541_();
        float roll = rng.m_188501_();
        float cDeflect = profile.baseDeflectChance();
        float cRicochet = cDeflect + profile.baseRicochetChance();
        float cSpall = cRicochet + profile.baseSpallChance();
        if (roll < cDeflect) {
            Vec3 out = BallisticsResolver.sampleConeAround(rng, reflection, profile.deflectConeRad());
            double speedMul = profile.sampleSpeedMultiplier(rng);
            return BallisticOutcome.deflect(out, speedMul);
        }
        if (roll < cRicochet) {
            Vec3 tangent = BallisticsResolver.sampleConeAround(rng, reflection, profile.ricochetConeRad());
            double speedMul = (double)profile.sampleSpeedMultiplier(rng) * 0.85;
            return BallisticOutcome.ricochet(tangent.m_82541_(), speedMul);
        }
        if (roll < cSpall) {
            return BallisticOutcome.spall(profile.spallCount(), profile.spallConeRad());
        }
        return BallisticOutcome.penetrate();
    }

    public static Vec3 sampleConeAround(RandomSource rng, Vec3 axis, float maxAngleRad) {
        Vec3 n = axis.m_82541_();
        Vec3 u = Math.abs(n.f_82479_) > Math.abs(n.f_82481_) ? new Vec3(-n.f_82480_, n.f_82479_, 0.0) : new Vec3(0.0, -n.f_82481_, n.f_82480_);
        u = u.m_82541_();
        Vec3 v = n.m_82537_(u);
        float angle = maxAngleRad * rng.m_188501_();
        float azimuth = (float)(rng.m_188500_() * Math.PI * 2.0);
        float sinA = (float)Math.sin(angle);
        float cosA = (float)Math.cos(angle);
        Vec3 radial = u.m_82490_(Math.cos(azimuth) * (double)sinA).m_82549_(v.m_82490_(Math.sin(azimuth) * (double)sinA));
        Vec3 dir = n.m_82490_((double)cosA).m_82549_(radial);
        return dir.m_82541_();
    }
}

