/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.ballistics;

import net.minecraft.util.RandomSource;

public record DeflectionProfile(float baseDeflectChance, float baseRicochetChance, float baseSpallChance, float deflectConeRad, float ricochetConeRad, float spallConeRad, int spallCount, float minSpeedMul, float maxSpeedMul, float bluntFracDeflect, float bluntFracRicochet, float bluntFracSpall, float knockbackPerDamage, float durabilityPerDamage) {
    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static float clamp01(float v) {
        return Math.max(0.0f, Math.min(1.0f, v));
    }

    public DeflectionProfile interpolateByDurability(float durabilityFraction) {
        float t = DeflectionProfile.clamp01(durabilityFraction);
        float deflect = DeflectionProfile.lerp(this.baseDeflectChance * 0.4f, this.baseDeflectChance, t);
        float ricochet = DeflectionProfile.lerp(this.baseRicochetChance * 0.7f, this.baseRicochetChance, t);
        float spall = DeflectionProfile.lerp(this.baseSpallChance * 1.6f, this.baseSpallChance, t);
        float deflectCone = DeflectionProfile.lerp(this.deflectConeRad * 1.4f, this.deflectConeRad, t);
        float ricochetCone = DeflectionProfile.lerp(this.ricochetConeRad * 1.25f, this.ricochetConeRad, t);
        float spallCone = DeflectionProfile.lerp(this.spallConeRad * 1.1f, this.spallConeRad, t);
        float minMul = DeflectionProfile.lerp(this.minSpeedMul * 0.9f, this.minSpeedMul, t);
        float maxMul = DeflectionProfile.lerp(this.maxSpeedMul * 0.9f, this.maxSpeedMul, t);
        float bluntDeflect = DeflectionProfile.lerp(this.bluntFracDeflect * 1.2f, this.bluntFracDeflect, t);
        float bluntRicochet = DeflectionProfile.lerp(this.bluntFracRicochet * 1.2f, this.bluntFracRicochet, t);
        float bluntSpall = DeflectionProfile.lerp(this.bluntFracSpall * 1.3f, this.bluntFracSpall, t);
        float knockbackPD = this.knockbackPerDamage;
        float duraPD = DeflectionProfile.lerp(this.durabilityPerDamage * 1.2f, this.durabilityPerDamage, t);
        return new DeflectionProfile(deflect, ricochet, spall, deflectCone, ricochetCone, spallCone, this.spallCount, minMul, maxMul, bluntDeflect, bluntRicochet, bluntSpall, knockbackPD, duraPD);
    }

    public float sampleSpeedMultiplier(RandomSource rng) {
        return DeflectionProfile.lerp(this.minSpeedMul, this.maxSpeedMul, rng.m_188501_());
    }
}

