/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.ballistics;

import com.radar.biohazardchanges.common.ballistics.DeflectionProfile;

public final class DeflectionProfileBuilder {
    private float baseDeflectChance = 0.0f;
    private float baseRicochetChance = 0.0f;
    private float baseSpallChance = 0.0f;
    private float deflectConeRad = (float)Math.toRadians(20.0);
    private float ricochetConeRad = (float)Math.toRadians(35.0);
    private float spallConeRad = (float)Math.toRadians(30.0);
    private int spallCount = 6;
    private float minSpeedMul = 0.5f;
    private float maxSpeedMul = 0.9f;
    private float bluntFracDeflect = 0.05f;
    private float bluntFracRicochet = 0.1f;
    private float bluntFracSpall = 0.15f;
    private float knockbackPerDamage = 0.02f;
    private float durabilityPerDamage = 0.4f;

    public static DeflectionProfileBuilder create() {
        return new DeflectionProfileBuilder();
    }

    public DeflectionProfileBuilder chances(float deflect, float ricochet, float spall) {
        this.baseDeflectChance = deflect;
        this.baseRicochetChance = ricochet;
        this.baseSpallChance = spall;
        return this;
    }

    public DeflectionProfileBuilder deflectConeDeg(float degrees) {
        this.deflectConeRad = (float)Math.toRadians(degrees);
        return this;
    }

    public DeflectionProfileBuilder ricochetConeDeg(float degrees) {
        this.ricochetConeRad = (float)Math.toRadians(degrees);
        return this;
    }

    public DeflectionProfileBuilder spallConeDeg(float degrees) {
        this.spallConeRad = (float)Math.toRadians(degrees);
        return this;
    }

    public DeflectionProfileBuilder spallCount(int count) {
        this.spallCount = count;
        return this;
    }

    public DeflectionProfileBuilder speedMultiplierRange(float min, float max) {
        this.minSpeedMul = min;
        this.maxSpeedMul = max;
        return this;
    }

    public DeflectionProfileBuilder bluntFractions(float deflect, float ricochet, float spall) {
        this.bluntFracDeflect = deflect;
        this.bluntFracRicochet = ricochet;
        this.bluntFracSpall = spall;
        return this;
    }

    public DeflectionProfileBuilder knockbackPerDamage(float value) {
        this.knockbackPerDamage = value;
        return this;
    }

    public DeflectionProfileBuilder durabilityPerDamage(float value) {
        this.durabilityPerDamage = value;
        return this;
    }

    public DeflectionProfile build() {
        return new DeflectionProfile(this.baseDeflectChance, this.baseRicochetChance, this.baseSpallChance, this.deflectConeRad, this.ricochetConeRad, this.spallConeRad, this.spallCount, this.minSpeedMul, this.maxSpeedMul, this.bluntFracDeflect, this.bluntFracRicochet, this.bluntFracSpall, this.knockbackPerDamage, this.durabilityPerDamage);
    }
}

