/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.blocks;

import com.radar.biohazardchanges.common.blocks.blockentity.BlastDoorBE;
import com.radar.biohazardchanges.common.registry.BioBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlastDoorBlock
extends Block
implements EntityBlock {
    public static final int WIDTH = 5;
    public static final int HEIGHT = 5;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DoorLeaf> LEAF = EnumProperty.m_61587_((String)"leaf", DoorLeaf.class);
    public static final IntegerProperty PROGRESS = IntegerProperty.m_61631_((String)"progress", (int)0, (int)15);
    private static final IntegerProperty COLUMN = IntegerProperty.m_61631_((String)"column", (int)0, (int)9);
    private static final IntegerProperty LEVEL_ID = IntegerProperty.m_61631_((String)"level", (int)0, (int)4);
    private static final VoxelShape[][][] SHAPES = BlastDoorBlock.bakeShapes();

    public BlastDoorBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(LEAF, (Comparable)((Object)DoorLeaf.LEFT))).m_61124_((Property)PROGRESS, (Comparable)Integer.valueOf(0))).m_61124_((Property)COLUMN, (Comparable)Integer.valueOf(0))).m_61124_((Property)LEVEL_ID, (Comparable)Integer.valueOf(0)));
    }

    private static VoxelShape[][][] bakeShapes() {
        VoxelShape[][][] shapes = new VoxelShape[16][2][4];
        int[] directionMap = new int[]{0, 1, 2, 3};
        for (int progress = 0; progress <= 15; ++progress) {
            double t = 1.0 - (double)progress / 15.0;
            shapes[progress][0][0] = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)t, (double)1.0, (double)1.0);
            shapes[progress][1][0] = Shapes.m_83048_((double)(1.0 - t), (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            shapes[progress][0][1] = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)t);
            shapes[progress][1][1] = Shapes.m_83048_((double)0.0, (double)0.0, (double)(1.0 - t), (double)1.0, (double)1.0, (double)1.0);
            shapes[progress][0][2] = Shapes.m_83048_((double)(1.0 - t), (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            shapes[progress][1][2] = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)t, (double)1.0, (double)1.0);
            shapes[progress][0][3] = Shapes.m_83048_((double)0.0, (double)0.0, (double)(1.0 - t), (double)1.0, (double)1.0, (double)1.0);
            shapes[progress][1][3] = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)t);
        }
        return shapes;
    }

    private static boolean isController(BlockState st) {
        return (Integer)st.m_61143_((Property)COLUMN) == 0 && (Integer)st.m_61143_((Property)LEVEL_ID) == 0;
    }

    private static BlockPos controllerPos(BlockPos pos, BlockState st) {
        Direction left = ((Direction)st.m_61143_((Property)FACING)).m_122427_();
        return pos.m_5484_(left, -((Integer)st.m_61143_((Property)COLUMN)).intValue()).m_6625_(((Integer)st.m_61143_((Property)LEVEL_ID)).intValue());
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return 15 - (Integer)state.m_61143_((Property)PROGRESS) * 15 / 15;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LEAF, PROGRESS, COLUMN, LEVEL_ID});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    public BlockState m_6843_(BlockState st, Rotation rot) {
        return (BlockState)st.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)st.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState st, Mirror mirror) {
        return this.m_6843_(st, mirror.m_54846_((Direction)st.m_61143_((Property)FACING)));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!BlastDoorBlock.isController(state)) {
            return;
        }
        if (level.f_46443_ || isMoving) {
            return;
        }
        Direction left = ((Direction)state.m_61143_((Property)FACING)).m_122427_();
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 5; ++y) {
                BlockPos p = pos.m_5484_(left, x).m_6630_(y);
                BlockState part = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(LEAF, (Comparable)((Object)(x < 5 ? DoorLeaf.LEFT : DoorLeaf.RIGHT)))).m_61124_((Property)PROGRESS, (Comparable)Integer.valueOf(0))).m_61124_((Property)COLUMN, (Comparable)Integer.valueOf(x))).m_61124_((Property)LEVEL_ID, (Comparable)Integer.valueOf(y));
                if (p.equals((Object)pos)) continue;
                level.m_7731_(p, part, 3);
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            this.destroyWholeDoor(level, state, pos);
        }
        super.m_5707_(level, pos, state, player);
    }

    private void destroyWholeDoor(Level level, BlockState st, BlockPos anyPart) {
        BlockPos controller = BlastDoorBlock.controllerPos(anyPart, st);
        Direction left = ((Direction)st.m_61143_((Property)FACING)).m_122427_();
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 5; ++y) {
                level.m_46961_(controller.m_5484_(left, x).m_6630_(y), true);
            }
        }
    }

    public InteractionResult m_6227_(BlockState st, Level lvl, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (lvl.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos ctrl = BlastDoorBlock.controllerPos(pos, st);
        BlockEntity be = lvl.m_7702_(ctrl);
        if (be instanceof BlastDoorBE) {
            BlastDoorBE door = (BlastDoorBE)be;
            door.toggle();
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5939_(BlockState st, BlockGetter lvl, BlockPos pos, CollisionContext ctx) {
        int q = (Integer)st.m_61143_((Property)PROGRESS);
        if (q == 15) {
            return Shapes.m_83040_();
        }
        float slide = (float)q / 15.0f * 5.0f;
        int colFromSeam = st.m_61143_(LEAF) == DoorLeaf.LEFT ? 4 - (Integer)st.m_61143_((Property)COLUMN) : (Integer)st.m_61143_((Property)COLUMN) - 5;
        float remain = 1.0f - (slide - (float)colFromSeam);
        if ((remain = Mth.m_14036_((float)remain, (float)0.0f, (float)1.0f)) == 0.0f) {
            return Shapes.m_83040_();
        }
        Direction facing = (Direction)st.m_61143_((Property)FACING);
        Direction leftDir = facing.m_122427_();
        Direction slideDir = st.m_61143_(LEAF) == DoorLeaf.LEFT ? leftDir.m_122424_() : leftDir;
        boolean alongX = slideDir.m_122434_() == Direction.Axis.X;
        boolean plus = (alongX ? slideDir.m_122429_() : slideDir.m_122431_()) > 0;
        float min = plus ? 0.0f : 1.0f - remain;
        float max = plus ? remain : 1.0f;
        return alongX ? Shapes.m_83048_((double)min, (double)0.0, (double)0.0, (double)max, (double)1.0, (double)1.0) : Shapes.m_83048_((double)0.0, (double)0.0, (double)min, (double)1.0, (double)1.0, (double)max);
    }

    public VoxelShape m_6079_(BlockState s, BlockGetter g, BlockPos p) {
        return this.m_5939_(s, g, p, CollisionContext.m_82749_());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState st) {
        return BlastDoorBlock.isController(st) ? new BlastDoorBE(pos, st) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level lvl, BlockState st, BlockEntityType<T> type) {
        return type == BioBlockEntities.BLAST_DOOR_BE.get() ? BlastDoorBE.SERVER_TICKER : null;
    }

    public RenderShape m_7514_(BlockState s) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Integer)state.m_61143_((Property)PROGRESS) > 10;
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.m_188503_(10) == 0) {
            pLevel.m_7260_(pPos, pState, pState, 3);
        }
    }

    public static enum DoorLeaf implements StringRepresentable
    {
        LEFT,
        RIGHT;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

