/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.blocks;

import com.radar.biohazardchanges.common.blocks.MegaBlock;
import com.radar.biohazardchanges.common.blocks.blockentity.BlastDoorBE;
import com.radar.biohazardchanges.common.registry.BioBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlastDoorBlockV2
extends MegaBlock {
    public static final EnumProperty<DoorLeaf> LEAF = EnumProperty.m_61587_((String)"leaf", DoorLeaf.class);
    public static final IntegerProperty PROGRESS = IntegerProperty.m_61631_((String)"progress", (int)0, (int)15);
    private static final int LEAF_WIDTH = 5;
    private static final int TOTAL_WIDTH = 10;
    private static final int HEIGHT = 5;
    private static final int DEPTH = 1;
    private static final VoxelShape[][][][] SHAPES = BlastDoorBlockV2.bakeShapes();

    public BlastDoorBlockV2(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(LEAF, (Comparable)((Object)DoorLeaf.LEFT))).m_61124_((Property)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    private static int getFacingIndex(Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> 0;
            case Direction.EAST -> 1;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            default -> 0;
        };
    }

    private static VoxelShape[][][][] bakeShapes() {
        VoxelShape[][][][] shapes = new VoxelShape[16][2][5][4];
        for (int progress = 0; progress <= 15; ++progress) {
            float slide = (float)progress / 15.0f * 5.0f;
            for (int column = 0; column < 5; ++column) {
                float leftRemain = BlastDoorBlockV2.calculateRemaining(column, slide, true);
                float rightRemain = BlastDoorBlockV2.calculateRemaining(column, slide, false);
                for (int facing = 0; facing < 4; ++facing) {
                    shapes[progress][0][column][facing] = BlastDoorBlockV2.bakeColumnShape(leftRemain, facing, true);
                    shapes[progress][1][column][facing] = BlastDoorBlockV2.bakeColumnShape(rightRemain, facing, false);
                }
            }
        }
        return shapes;
    }

    private static float calculateRemaining(int column, float slide, boolean isLeft) {
        int colFromSeam = isLeft ? 4 - column : column;
        float remain = 1.0f - (slide - (float)colFromSeam);
        return Mth.m_14036_((float)remain, (float)0.0f, (float)1.0f);
    }

    private static VoxelShape bakeColumnShape(float thickness, int facingIndex, boolean isLeft) {
        if (thickness <= 0.0f) {
            return Shapes.m_83040_();
        }
        return switch (facingIndex) {
            case 0 -> {
                if (isLeft) {
                    yield Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)thickness, (double)1.0, (double)1.0);
                }
                yield Shapes.m_83048_((double)(1.0f - thickness), (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
            case 1 -> {
                if (isLeft) {
                    yield Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)thickness);
                }
                yield Shapes.m_83048_((double)0.0, (double)0.0, (double)(1.0f - thickness), (double)1.0, (double)1.0, (double)1.0);
            }
            case 2 -> {
                if (isLeft) {
                    yield Shapes.m_83048_((double)(1.0f - thickness), (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
                }
                yield Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)thickness, (double)1.0, (double)1.0);
            }
            case 3 -> {
                if (isLeft) {
                    yield Shapes.m_83048_((double)0.0, (double)0.0, (double)(1.0f - thickness), (double)1.0, (double)1.0, (double)1.0);
                }
                yield Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)thickness);
            }
            default -> Shapes.m_83144_();
        };
    }

    @Override
    public int[] getDimensions() {
        return new int[]{10, 5, 1};
    }

    @Override
    public boolean isController(int partX, int partY, int partZ) {
        return partX == 0 && partY == 0 && partZ == 0;
    }

    @Override
    public VoxelShape getPartShape(BlockState state, int partX, int partY, int partZ) {
        int progress = (Integer)state.m_61143_((Property)PROGRESS);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        DoorLeaf leaf = partX < 5 ? DoorLeaf.LEFT : DoorLeaf.RIGHT;
        int leafX = partX < 5 ? partX : partX - 5;
        int facingIndex = BlastDoorBlockV2.getFacingIndex(facing);
        return SHAPES[progress][leaf.ordinal()][leafX][facingIndex];
    }

    @Override
    protected void addCustomProperties(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LEAF, PROGRESS});
    }

    @Override
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!this.isController(0, 0, 0)) {
            return;
        }
        if (level.f_46443_ || isMoving) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction right = facing.m_122427_();
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 5; ++y) {
                BlockPos partPos = pos.m_5484_(right, x).m_6630_(y);
                if (partPos.equals((Object)pos)) continue;
                BlockState partState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)PART_X, (Comparable)Integer.valueOf(x))).m_61124_((Property)PART_Y, (Comparable)Integer.valueOf(y))).m_61124_((Property)PART_Z, (Comparable)Integer.valueOf(0))).m_61124_(LEAF, (Comparable)((Object)(x < 5 ? DoorLeaf.LEFT : DoorLeaf.RIGHT)))).m_61124_((Property)PROGRESS, (Comparable)Integer.valueOf(0));
                level.m_7731_(partPos, partState, 3);
            }
        }
    }

    @Override
    protected InteractionResult handleInteraction(BlockEntity controllerEntity, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (controllerEntity instanceof BlastDoorBE) {
            BlastDoorBE door = (BlastDoorBE)controllerEntity;
            door.toggle();
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    protected BlockEntity createControllerBlockEntity(BlockPos pos, BlockState state) {
        return new BlastDoorBE(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == BioBlockEntities.BLAST_DOOR_BE.get() && this.isController((Integer)state.m_61143_((Property)PART_X), (Integer)state.m_61143_((Property)PART_Y), (Integer)state.m_61143_((Property)PART_Z)) ? BlastDoorBE.SERVER_TICKER : null;
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void updateProgress(Level level, BlockPos controllerPos, BlockState controllerState, int newProgress) {
        if (level.f_46443_) {
            return;
        }
        Direction facing = (Direction)controllerState.m_61143_((Property)FACING);
        Direction right = facing.m_122427_();
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 5; ++y) {
                BlockPos partPos = controllerPos.m_5484_(right, x).m_6630_(y);
                BlockState partState = level.m_8055_(partPos);
                if (partState.m_60734_() != this || !partState.m_61138_((Property)PROGRESS)) continue;
                level.m_7731_(partPos, (BlockState)partState.m_61124_((Property)PROGRESS, (Comparable)Integer.valueOf(newProgress)), 2);
            }
        }
    }

    @Override
    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Integer)state.m_61143_((Property)PROGRESS) > 10;
    }

    @Override
    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        int progress = (Integer)state.m_61143_((Property)PROGRESS);
        return Math.max(0, 15 - progress);
    }

    public static enum DoorLeaf implements StringRepresentable
    {
        LEFT,
        RIGHT;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

