/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.blocks;

import com.radar.biohazardchanges.common.blocks.MegaBlockHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class MegaBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty PART_X = IntegerProperty.m_61631_((String)"part_x", (int)0, (int)15);
    public static final IntegerProperty PART_Y = IntegerProperty.m_61631_((String)"part_y", (int)0, (int)15);
    public static final IntegerProperty PART_Z = IntegerProperty.m_61631_((String)"part_z", (int)0, (int)15);

    protected MegaBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)PART_X, (Comparable)Integer.valueOf(0))).m_61124_((Property)PART_Y, (Comparable)Integer.valueOf(0))).m_61124_((Property)PART_Z, (Comparable)Integer.valueOf(0)));
    }

    public abstract int[] getDimensions();

    public abstract VoxelShape getPartShape(BlockState var1, int var2, int var3, int var4);

    public abstract boolean isController(int var1, int var2, int var3);

    public BlockPos getControllerPos(BlockPos pos, BlockState state) {
        int partX = (Integer)state.m_61143_((Property)PART_X);
        int partY = (Integer)state.m_61143_((Property)PART_Y);
        int partZ = (Integer)state.m_61143_((Property)PART_Z);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction right = facing.m_122427_();
        Direction up = Direction.UP;
        return pos.m_5484_(facing, -partZ).m_5484_(right, -partX).m_5484_(up, -partY);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int partX = (Integer)state.m_61143_((Property)PART_X);
        int partY = (Integer)state.m_61143_((Property)PART_Y);
        int partZ = (Integer)state.m_61143_((Property)PART_Z);
        return this.getPartShape(state, partX, partY, partZ);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, level, pos, context);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.m_5940_(state, level, pos, CollisionContext.m_82749_());
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return 0;
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7923_(BlockState state) {
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!this.isController(0, 0, 0)) {
            return;
        }
        if (level.f_46443_ || isMoving) {
            return;
        }
        MegaBlockHelper.placeStructure(this, level, pos, state);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_ && !player.m_7500_()) {
            BlockPos controllerPos = this.getControllerPos(pos, state);
            MegaBlockHelper.breakStructure(this, level, controllerPos, state, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(state.m_60713_(newState.m_60734_()) || level.f_46443_ || isMoving)) {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return this.m_6843_(state, mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos controllerPos = this.getControllerPos(pos, state);
        BlockEntity be = level.m_7702_(controllerPos);
        return this.handleInteraction(be, state, level, pos, player, hand, hit);
    }

    protected InteractionResult handleInteraction(BlockEntity controllerEntity, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART_X, PART_Y, PART_Z});
        this.addCustomProperties(builder);
    }

    protected void addCustomProperties(StateDefinition.Builder<Block, BlockState> builder) {
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        int partZ;
        int partY;
        int partX = (Integer)state.m_61143_((Property)PART_X);
        if (this.isController(partX, partY = ((Integer)state.m_61143_((Property)PART_Y)).intValue(), partZ = ((Integer)state.m_61143_((Property)PART_Z)).intValue())) {
            return this.createControllerBlockEntity(pos, state);
        }
        return null;
    }

    @Nullable
    protected abstract BlockEntity createControllerBlockEntity(BlockPos var1, BlockState var2);
}

