/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.blocks;

import com.radar.biohazardchanges.common.blocks.MegaBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MegaBlockHelper {
    public static void placeStructure(MegaBlock megaBlock, Level level, BlockPos controllerPos, BlockState controllerState) {
        int[] dimensions = megaBlock.getDimensions();
        int width = dimensions[0];
        int height = dimensions[1];
        int depth = dimensions[2];
        Direction facing = (Direction)controllerState.m_61143_((Property)MegaBlock.FACING);
        Direction right = facing.m_122427_();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < depth; ++z) {
                    BlockPos partPos = controllerPos.m_5484_(right, x).m_5484_(Direction.UP, y).m_5484_(facing, z);
                    if (partPos.equals((Object)controllerPos)) continue;
                    BlockState partState = (BlockState)((BlockState)((BlockState)controllerState.m_61124_((Property)MegaBlock.PART_X, (Comparable)Integer.valueOf(x))).m_61124_((Property)MegaBlock.PART_Y, (Comparable)Integer.valueOf(y))).m_61124_((Property)MegaBlock.PART_Z, (Comparable)Integer.valueOf(z));
                    level.m_7731_(partPos, partState, 3);
                }
            }
        }
    }

    public static void breakStructure(MegaBlock megaBlock, Level level, BlockPos controllerPos, BlockState controllerState, BlockPos brokenPos) {
        int[] dimensions = megaBlock.getDimensions();
        int width = dimensions[0];
        int height = dimensions[1];
        int depth = dimensions[2];
        Direction facing = (Direction)controllerState.m_61143_((Property)MegaBlock.FACING);
        Direction right = facing.m_122427_();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < depth; ++z) {
                    BlockPos partPos = controllerPos.m_5484_(right, x).m_5484_(Direction.UP, y).m_5484_(facing, z);
                    BlockState currentState = level.m_8055_(partPos);
                    if (currentState.m_60734_() != megaBlock) continue;
                    if (partPos.equals((Object)brokenPos)) {
                        level.m_46961_(partPos, true);
                        continue;
                    }
                    level.m_7731_(partPos, Blocks.f_50016_.m_49966_(), 35);
                }
            }
        }
    }

    public static boolean canPlaceStructure(MegaBlock megaBlock, Level level, BlockPos controllerPos, Direction facing) {
        int[] dimensions = megaBlock.getDimensions();
        int width = dimensions[0];
        int height = dimensions[1];
        int depth = dimensions[2];
        Direction right = facing.m_122427_();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < depth; ++z) {
                    BlockState existingState;
                    BlockPos partPos = controllerPos.m_5484_(right, x).m_5484_(Direction.UP, y).m_5484_(facing, z);
                    if (x == 0 && y == 0 && z == 0 || (existingState = level.m_8055_(partPos)).m_247087_()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static BlockPos[] getStructureBounds(MegaBlock megaBlock, BlockPos controllerPos, Direction facing) {
        int[] dimensions = megaBlock.getDimensions();
        int width = dimensions[0];
        int height = dimensions[1];
        int depth = dimensions[2];
        Direction right = facing.m_122427_();
        BlockPos minPos = controllerPos;
        BlockPos maxPos = controllerPos.m_5484_(right, width - 1).m_5484_(Direction.UP, height - 1).m_5484_(facing, depth - 1);
        return new BlockPos[]{minPos, maxPos};
    }

    public static BlockPos localToWorld(BlockPos controllerPos, Direction facing, int localX, int localY, int localZ) {
        Direction right = facing.m_122427_();
        return controllerPos.m_5484_(right, localX).m_5484_(Direction.UP, localY).m_5484_(facing, localZ);
    }

    public static int[] worldToLocal(BlockPos controllerPos, Direction facing, BlockPos worldPos) {
        Direction right = facing.m_122427_();
        BlockPos relative = worldPos.m_121996_((Vec3i)controllerPos);
        int localX = relative.m_123341_() * right.m_122429_() + relative.m_123343_() * right.m_122431_();
        int localY = relative.m_123342_();
        int localZ = relative.m_123341_() * facing.m_122429_() + relative.m_123343_() * facing.m_122431_();
        return new int[]{localX, localY, localZ};
    }
}

