/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.blocks;

import com.radar.biohazardchanges.common.blocks.MegaBlock;
import com.radar.biohazardchanges.common.blocks.MegaBlockHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SimpleMegaBlock
extends MegaBlock {
    public static final BooleanProperty EXPANDED = BooleanProperty.m_61465_((String)"expanded");
    public static final IntegerProperty FRAME = IntegerProperty.m_61631_((String)"frame", (int)0, (int)15);
    private static final int SIZE = 3;

    public SimpleMegaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)EXPANDED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FRAME, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public int[] getDimensions() {
        return new int[]{3, 3, 3};
    }

    @Override
    public boolean isController(int partX, int partY, int partZ) {
        return partX == 1 && partY == 0 && partZ == 1;
    }

    @Override
    public VoxelShape getPartShape(BlockState state, int partX, int partY, int partZ) {
        boolean expanded = (Boolean)state.m_61143_((Property)EXPANDED);
        int frame = (Integer)state.m_61143_((Property)FRAME);
        if (partX == 1 && partZ == 1) {
            return Shapes.m_83144_();
        }
        if (expanded) {
            return Shapes.m_83144_();
        }
        double size = 0.5 + (double)frame / 15.0 * 0.5;
        double offset = (1.0 - size) / 2.0;
        return Shapes.m_83048_((double)offset, (double)offset, (double)offset, (double)(1.0 - offset), (double)(1.0 - offset), (double)(1.0 - offset));
    }

    @Override
    protected void addCustomProperties(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{EXPANDED, FRAME});
    }

    @Override
    protected InteractionResult handleInteraction(BlockEntity controllerEntity, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            boolean newExpanded = (Boolean)state.m_61143_((Property)EXPANDED) == false;
            this.updateAllParts(level, this.getControllerPos(pos, state), state, newExpanded);
            level.m_46796_(newExpanded ? 1001 : 1000, pos, 0);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private void updateAllParts(Level level, BlockPos controllerPos, BlockState controllerState, boolean expanded) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = 0; z < 3; ++z) {
                    BlockPos partPos = MegaBlockHelper.localToWorld(controllerPos, (Direction)controllerState.m_61143_((Property)FACING), x, y, z);
                    BlockState partState = level.m_8055_(partPos);
                    if (partState.m_60734_() != this) continue;
                    level.m_7731_(partPos, (BlockState)partState.m_61124_((Property)EXPANDED, (Comparable)Boolean.valueOf(expanded)), 3);
                }
            }
        }
    }

    @Override
    @Nullable
    protected BlockEntity createControllerBlockEntity(BlockPos pos, BlockState state) {
        return null;
    }

    public void tick(BlockState state, Level level, BlockPos pos) {
        if (!level.f_46443_ && this.isController((Integer)state.m_61143_((Property)PART_X), (Integer)state.m_61143_((Property)PART_Y), (Integer)state.m_61143_((Property)PART_Z))) {
            int currentFrame = (Integer)state.m_61143_((Property)FRAME);
            int nextFrame = (currentFrame + 1) % 16;
            this.updateFrame(level, pos, state, nextFrame);
        }
    }

    private void updateFrame(Level level, BlockPos controllerPos, BlockState controllerState, int frame) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = 0; z < 3; ++z) {
                    BlockPos partPos = MegaBlockHelper.localToWorld(controllerPos, (Direction)controllerState.m_61143_((Property)FACING), x, y, z);
                    BlockState partState = level.m_8055_(partPos);
                    if (partState.m_60734_() != this || !partState.m_61138_((Property)FRAME)) continue;
                    level.m_7731_(partPos, (BlockState)partState.m_61124_((Property)FRAME, (Comparable)Integer.valueOf(frame)), 2);
                }
            }
        }
    }
}

