/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.blocks.blockentity;

import com.radar.biohazardchanges.common.registry.BioBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AntennaBE
extends BlockEntity
implements GeoBlockEntity {
    private final SavableEnergyStorage energy = new SavableEnergyStorage(100000, 500, 500);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AntennaBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BioBlockEntities.ANTENNA_BE.get(), pos, state);
    }

    @Nullable
    public static AntennaBE findNearestPoweredAntenna(Level level, BlockPos center) {
        int radius = 32;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    cursor.m_122178_(center.m_123341_() + dx, center.m_123342_() + dy, center.m_123343_() + dz);
                    BlockEntity be = level.m_7702_((BlockPos)cursor);
                    if (!(be instanceof AntennaBE)) continue;
                    AntennaBE antenna = (AntennaBE)be;
                    if (antenna.energy.getEnergyStored() <= 0) continue;
                    return antenna;
                }
            }
        }
        return null;
    }

    @Nullable
    public static AntennaBE findNearestAntenna(Level level, BlockPos center) {
        int radius = 32;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    cursor.m_122178_(center.m_123341_() + dx, center.m_123342_() + dy, center.m_123343_() + dz);
                    BlockEntity be = level.m_7702_((BlockPos)cursor);
                    if (!(be instanceof AntennaBE)) continue;
                    AntennaBE antenna = (AntennaBE)be;
                    return antenna;
                }
            }
        }
        return null;
    }

    public void serverTick() {
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energy;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Energy", this.energy.getEnergyStored());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        int stored = tag.m_128451_("Energy");
        this.energy.setEnergyDirect(stored);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, state -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82377_(1.0, 8.0, 1.0);
    }

    private static class SavableEnergyStorage
    extends EnergyStorage {
        public SavableEnergyStorage(int capacity, int maxReceive, int maxExtract) {
            super(capacity, maxReceive, maxExtract);
        }

        public void setEnergyDirect(int amount) {
            this.energy = Math.max(0, Math.min(amount, this.capacity));
        }
    }
}

