/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.blocks.blockentity;

import com.radar.biohazardchanges.common.blocks.BlastDoorBlock;
import com.radar.biohazardchanges.common.registry.BioBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BlastDoorBE
extends BlockEntity
implements GeoBlockEntity {
    protected static final RawAnimation DEPLOY_ANIM = RawAnimation.begin().thenPlayAndHold("animation.idle");
    protected static final RawAnimation OPEN_ANIM = RawAnimation.begin().thenPlayAndHold("animation.open");
    protected static final RawAnimation CLOSE_ANIM = RawAnimation.begin().thenPlayAndHold("animation.close");
    private static final float SPEED = 0.0045454544f;
    public static final BlockEntityTicker<BlastDoorBE> SERVER_TICKER = (lvl, pos, st, be) -> {
        float target;
        if (lvl.f_46443_) {
            return;
        }
        float f = target = be.shouldOpen ? 1.0f : 0.0f;
        if (Mth.m_14033_((float)be.progress, (float)target)) {
            if (target == 0.0f && !be.burstAfterClose) {
                be.burstEndClose();
                be.burstAfterClose = true;
            }
            return;
        }
        boolean atStart = Mth.m_14033_((float)be.progress, (float)0.0f);
        if (atStart && be.shouldOpen) {
            be.puffStartOpen();
            be.burstAfterClose = false;
        }
        be.progress = Mth.m_14036_((float)(be.progress + Math.copySign(0.0045454544f, target - be.progress)), (float)0.0f, (float)1.0f);
        int q = Mth.m_14143_((float)(be.progress * 15.0f + 0.5f));
        if (q != (Integer)st.m_61143_((Property)BlastDoorBlock.PROGRESS)) {
            Direction leftDir = ((Direction)st.m_61143_((Property)BlastDoorBlock.FACING)).m_122427_();
            for (int x = 0; x < 10; ++x) {
                for (int y = 0; y < 5; ++y) {
                    BlockPos p = pos.m_5484_(leftDir, x).m_6630_(y);
                    BlockState part = lvl.m_8055_(p);
                    if (!(part.m_60734_() instanceof BlastDoorBlock) || !part.m_61138_((Property)BlastDoorBlock.PROGRESS)) continue;
                    lvl.m_7731_(p, (BlockState)part.m_61124_((Property)BlastDoorBlock.PROGRESS, (Comparable)Integer.valueOf(q)), 2);
                }
            }
        }
    };
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean shouldOpen = false;
    private float progress = 0.0f;
    private boolean burstAfterClose = false;

    public BlastDoorBE(BlockPos pos, BlockState st) {
        super((BlockEntityType)BioBlockEntities.BLAST_DOOR_BE.get(), pos, st);
    }

    private void puffStartOpen() {
        this.spawnSmoke(6, 0.02);
    }

    private void burstEndClose() {
        this.spawnSmoke(20, 0.05);
    }

    private void spawnSmoke(int count, double spread) {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel srv = (ServerLevel)level;
        BlockState st = this.m_58900_();
        Direction leftDir = ((Direction)st.m_61143_((Property)BlastDoorBlock.FACING)).m_122427_();
        double baseX = (double)this.f_58858_.m_123341_() + 0.5 + (double)leftDir.m_122429_() * 4.5;
        double baseZ = (double)this.f_58858_.m_123343_() + 0.5 + (double)leftDir.m_122431_() * 4.5;
        double baseY = (double)this.f_58858_.m_123342_() + 2.5;
        srv.m_7106_((ParticleOptions)ParticleTypes.f_123796_, baseX, baseY, baseZ, spread, 0.02, spread);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "door", 0, state -> state.setAndContinue(DEPLOY_ANIM)).triggerableAnim("open", OPEN_ANIM).triggerableAnim("close", CLOSE_ANIM)});
    }

    protected <E extends BlastDoorBE> PlayState deployAnimController(AnimationState<E> state) {
        return state.setAndContinue(DEPLOY_ANIM);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void toggle() {
        boolean bl = this.shouldOpen = !this.shouldOpen;
        if (this.f_58857_ instanceof ServerLevel) {
            this.triggerAnim("door", this.shouldOpen ? "open" : "close");
            this.m_6596_();
        }
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82377_(10.0, 5.0, 10.0);
    }
}

