/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.blocks.blockentity;

import com.radar.biohazardchanges.Config;
import com.radar.biohazardchanges.common.blocks.ConsoleBlock;
import com.radar.biohazardchanges.common.blocks.blockentity.AntennaBE;
import com.radar.biohazardchanges.common.explore.ExplorationPool;
import com.radar.biohazardchanges.common.locate.AsyncLocatorService;
import com.radar.biohazardchanges.common.locate.StructureEnergyRegistry;
import com.radar.biohazardchanges.common.menu.ConsoleMenu;
import com.radar.biohazardchanges.common.registry.BioBlockEntities;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ConsoleBE
extends BlockEntity
implements MenuProvider,
GeoBlockEntity {
    private static final int CONSOLE_SUSTAIN_COST_PER_TICK = 10;
    private final SavableEnergyStorage energy = new SavableEnergyStorage(100000, 200, 200);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int searchProgress;
    private boolean linkedToAntenna;
    private ResourceLocation pendingStructure;
    private int pendingRadius;
    private BlockPos lastFound;
    private int selectedIndex;
    private int startupPaid;
    private boolean antennaPowered;
    private int lastAntennaEnergy;
    private int lastAntennaMaxEnergy;
    private boolean pendingFindUnexplored;
    private boolean lastFoundWasExplored;
    private boolean unexploredPreference = true;
    private boolean lastLocateFailed;

    public ConsoleBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BioBlockEntities.CONSOLE_BE.get(), pos, state);
    }

    private static ResourceLocation getWhitelistedStructureIdServer(int index) {
        List list = (List)Config.LOCATOR_WHITELIST.get();
        if (list == null || list.isEmpty()) {
            return ResourceLocation.parse((String)"minecraft:village_plains");
        }
        int i = Math.max(0, Math.min(index, list.size() - 1));
        String str = (String)list.get(i);
        ResourceLocation id = ResourceLocation.m_135820_((String)str);
        if (id == null) {
            id = ResourceLocation.parse((String)"minecraft:village_plains");
        }
        return id;
    }

    public void serverTick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        AntennaBE anyAntenna = AntennaBE.findNearestAntenna(this.f_58857_, this.f_58858_);
        AntennaBE poweredAntenna = AntennaBE.findNearestPoweredAntenna(this.f_58857_, this.f_58858_);
        this.linkedToAntenna = anyAntenna != null;
        this.antennaPowered = poweredAntenna != null;
        boolean consoleHasPower = this.energy.getEnergyStored() > 0;
        this.lastAntennaEnergy = poweredAntenna != null ? poweredAntenna.getEnergyStorage().getEnergyStored() : 0;
        int n = this.lastAntennaMaxEnergy = poweredAntenna != null ? poweredAntenna.getEnergyStorage().getMaxEnergyStored() : 0;
        if (this.linkedToAntenna) {
            if (this.pendingStructure != null) {
                StructureEnergyRegistry.EnergySpec spec = StructureEnergyRegistry.get(this.pendingStructure);
                if (this.searchProgress == 0) {
                    int remaining = Math.max(0, spec.startCost() - this.startupPaid);
                    int consoleUsedForStartup = 0;
                    if (consoleHasPower) {
                        consoleUsedForStartup = this.energy.extractEnergy(10, false);
                    }
                    if (remaining > 0 && this.antennaPowered) {
                        int paid = poweredAntenna.getEnergyStorage().extractEnergy(remaining, false);
                        this.startupPaid += paid;
                    }
                    if (this.startupPaid < spec.startCost() || consoleUsedForStartup < 10) {
                        this.updateIndicators();
                        this.m_6596_();
                        return;
                    }
                }
                int antennaUsed = 0;
                if (this.antennaPowered) {
                    antennaUsed = poweredAntenna.getEnergyStorage().extractEnergy(spec.sustainCostPerTick(), false);
                    this.lastAntennaEnergy = poweredAntenna.getEnergyStorage().getEnergyStored();
                    this.lastAntennaMaxEnergy = poweredAntenna.getEnergyStorage().getMaxEnergyStored();
                }
                int consoleUsed = 0;
                if (consoleHasPower) {
                    consoleUsed = this.energy.extractEnergy(10, false);
                }
                if (antennaUsed >= spec.sustainCostPerTick() && consoleUsed >= 10) {
                    if (this.searchProgress < 200) {
                        ++this.searchProgress;
                    }
                } else if (this.searchProgress > 0) {
                    --this.searchProgress;
                }
            }
        } else if (this.searchProgress > 0) {
            --this.searchProgress;
        }
        this.updateIndicators();
        if (this.searchProgress >= 200 && this.pendingStructure != null) {
            ServerLevel level = (ServerLevel)this.f_58857_;
            ResourceLocation structure = this.pendingStructure;
            int radius = this.pendingRadius;
            this.pendingStructure = null;
            List<ExplorationPool.VisitInfo> pool = ExplorationPool.query((Level)level, structure, this.pendingFindUnexplored, !this.pendingFindUnexplored, null);
            if (!pool.isEmpty()) {
                ExplorationPool.VisitInfo nearest = null;
                double nearestDist = Double.MAX_VALUE;
                for (ExplorationPool.VisitInfo vi : pool) {
                    double d = vi.structurePos.m_123331_((Vec3i)this.f_58858_);
                    if (!(d < nearestDist) || !(d <= (double)radius * (double)radius)) continue;
                    nearestDist = d;
                    nearest = vi;
                }
                if (nearest != null) {
                    this.lastFound = nearest.structurePos;
                    this.lastFoundWasExplored = nearest.explored();
                    this.lastLocateFailed = false;
                    this.m_6596_();
                    return;
                }
            }
            AsyncLocatorService.locate(level, structure, this.f_58858_, radius, this.pendingFindUnexplored).thenAccept(pair -> {
                if (pair != null) {
                    this.lastFound = (BlockPos)pair.getFirst();
                    Optional<ExplorationPool.VisitInfo> infoOpt = ExplorationPool.get((Level)level, structure, this.lastFound);
                    this.lastFoundWasExplored = infoOpt.map(ExplorationPool.VisitInfo::explored).orElse(false);
                    this.lastLocateFailed = false;
                    this.m_6596_();
                } else {
                    this.lastLocateFailed = true;
                    this.m_6596_();
                }
            });
        }
        this.m_6596_();
    }

    private void updateIndicators() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState st = this.f_58857_.m_8055_(this.f_58858_);
        if (st.m_60734_() instanceof ConsoleBlock) {
            boolean running;
            boolean powered = this.antennaPowered && this.energy.getEnergyStored() > 0;
            boolean bl = running = this.pendingStructure != null || this.searchProgress > 0 && this.searchProgress < 200;
            if ((Boolean)st.m_61143_((Property)ConsoleBlock.POWERED) != powered || (Boolean)st.m_61143_((Property)ConsoleBlock.LINKED) != this.linkedToAntenna || (Boolean)st.m_61143_((Property)ConsoleBlock.RUNNING) != running) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)((BlockState)((BlockState)st.m_61124_((Property)ConsoleBlock.POWERED, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)ConsoleBlock.LINKED, (Comparable)Boolean.valueOf(this.linkedToAntenna))).m_61124_((Property)ConsoleBlock.RUNNING, (Comparable)Boolean.valueOf(running)), 2);
            }
        }
    }

    public void refreshLinkNow() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.linkedToAntenna = AntennaBE.findNearestPoweredAntenna(this.f_58857_, this.f_58858_) != null;
        this.updateIndicators();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        this.m_6596_();
    }

    public boolean isLinkedToAntenna() {
        return this.linkedToAntenna;
    }

    public int getSearchProgress() {
        return this.searchProgress;
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energy;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("SearchProgress", this.searchProgress);
        tag.m_128379_("Linked", this.linkedToAntenna);
        tag.m_128405_("Energy", this.energy.getEnergyStored());
        if (this.pendingStructure != null) {
            tag.m_128359_("PendingStructure", this.pendingStructure.toString());
        }
        tag.m_128405_("PendingRadius", this.pendingRadius);
        if (this.lastFound != null) {
            tag.m_128356_("LastFound", this.lastFound.m_121878_());
        }
        tag.m_128405_("SelectedIndex", this.selectedIndex);
        tag.m_128405_("StartupPaid", this.startupPaid);
        tag.m_128379_("FoundExplored", this.lastFoundWasExplored);
        tag.m_128379_("UnexploredPref", this.unexploredPreference);
        tag.m_128379_("LocateFailed", this.lastLocateFailed);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.searchProgress = tag.m_128451_("SearchProgress");
        this.linkedToAntenna = tag.m_128471_("Linked");
        int stored = tag.m_128451_("Energy");
        this.energy.setEnergyDirect(stored);
        if (tag.m_128441_("PendingStructure")) {
            this.pendingStructure = ResourceLocation.parse((String)tag.m_128461_("PendingStructure"));
        }
        this.pendingRadius = tag.m_128451_("PendingRadius");
        if (tag.m_128441_("LastFound")) {
            this.lastFound = BlockPos.m_122022_((long)tag.m_128454_("LastFound"));
        }
        this.selectedIndex = tag.m_128451_("SelectedIndex");
        this.startupPaid = tag.m_128451_("StartupPaid");
        this.lastFoundWasExplored = tag.m_128471_("FoundExplored");
        this.unexploredPreference = tag.m_128471_("UnexploredPref");
        this.lastLocateFailed = tag.m_128471_("LocateFailed");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.biohazardchanges.console");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        ContainerData data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> ConsoleBE.this.searchProgress;
                    case 1 -> {
                        if (ConsoleBE.this.linkedToAntenna) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 2 -> ConsoleBE.this.energy.getEnergyStored();
                    case 3 -> ConsoleBE.this.energy.getMaxEnergyStored();
                    case 4 -> {
                        if (ConsoleBE.this.lastFound != null) {
                            yield ConsoleBE.this.lastFound.m_123341_();
                        }
                        yield Integer.MIN_VALUE;
                    }
                    case 5 -> {
                        if (ConsoleBE.this.lastFound != null) {
                            yield ConsoleBE.this.lastFound.m_123342_();
                        }
                        yield Integer.MIN_VALUE;
                    }
                    case 6 -> {
                        if (ConsoleBE.this.lastFound != null) {
                            yield ConsoleBE.this.lastFound.m_123343_();
                        }
                        yield Integer.MIN_VALUE;
                    }
                    case 7 -> {
                        if (ConsoleBE.this.antennaPowered) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 8 -> ConsoleBE.this.lastAntennaEnergy;
                    case 9 -> {
                        if (ConsoleBE.this.isSearching()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 10 -> {
                        if (ConsoleBE.this.wasLastFoundExplored()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 11 -> {
                        if (ConsoleBE.this.getUnexploredPreference()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 12 -> ConsoleBE.this.lastAntennaMaxEnergy;
                    case 13 -> {
                        if (ConsoleBE.this.lastLocateFailed) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
            }

            public int m_6499_() {
                return 14;
            }
        };
        return new ConsoleMenu(id, playerInventory, this.f_58858_, data);
    }

    public void requestSearch(ResourceLocation structureTag, int radius, boolean findUnexplored) {
        this.pendingStructure = structureTag;
        if (radius <= 0) {
            StructureEnergyRegistry.EnergySpec spec = StructureEnergyRegistry.get(structureTag);
            this.pendingRadius = spec.defaultRadius();
        } else {
            this.pendingRadius = radius;
        }
        this.searchProgress = 0;
        this.startupPaid = 0;
        this.lastFound = null;
        this.pendingFindUnexplored = findUnexplored;
        this.unexploredPreference = findUnexplored;
        this.lastLocateFailed = false;
        this.m_6596_();
    }

    public void cancelSearch() {
        this.pendingStructure = null;
        this.pendingRadius = 0;
        this.searchProgress = 0;
        this.startupPaid = 0;
        this.lastLocateFailed = false;
        this.m_6596_();
        this.updateIndicators();
    }

    public BlockPos getLastFound() {
        return this.lastFound;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int idx) {
        this.selectedIndex = Math.max(0, idx);
        this.m_6596_();
    }

    public boolean isAntennaPowered() {
        return this.antennaPowered;
    }

    public boolean isSearching() {
        return this.pendingStructure != null || this.searchProgress > 0 && this.searchProgress < 200;
    }

    public boolean wasLastFoundExplored() {
        return this.lastFoundWasExplored;
    }

    public boolean getUnexploredPreference() {
        return this.unexploredPreference;
    }

    public void setUnexploredPreference(boolean pref) {
        this.unexploredPreference = pref;
        this.m_6596_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, state -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private static class SavableEnergyStorage
    extends EnergyStorage {
        public SavableEnergyStorage(int capacity, int maxReceive, int maxExtract) {
            super(capacity, maxReceive, maxExtract);
        }

        public void setEnergyDirect(int amount) {
            this.energy = Math.max(0, Math.min(amount, this.capacity));
        }
    }
}

