/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.events;

import com.radar.biohazardchanges.Biohazardchanges;
import com.radar.biohazardchanges.common.ballistics.BallisticOutcome;
import com.radar.biohazardchanges.common.ballistics.BallisticsResolver;
import com.radar.biohazardchanges.common.ballistics.DeflectionProfile;
import com.radar.biohazardchanges.common.ballistics.DeflectionProfileBuilder;
import com.radar.biohazardchanges.common.ballistics.IDeflectionMaterial;
import com.radar.biohazardchanges.common.network.NetworkHandler;
import com.radar.biohazardchanges.common.network.S2CSpawnParticlesPacket;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.init.ModSounds;
import com.tacz.guns.item.ModernKineticGunItem;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="biohazardchanges", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BulletDeflectionHandler {
    private static final double DEFLECTED_BULLET_BASE_SPEED = 4.0;
    private static final double BULLET_SPREAD = 0.15;
    private static final double SHIELD_FORWARD_OFFSET = 0.6;
    private static final double PARTICLE_FRONT_OFFSET = 0.25;
    private static final double PARTICLE_BACK_OFFSET = 0.25;
    private static final double MAX_PLAYER_KNOCKBACK = 0.2;
    private static final double KNOCKBACK_RESPONSE = 0.05;
    private static final ThreadLocal<RandomSource> RANDOM_THREAD_LOCAL = ThreadLocal.withInitial(RandomSource::m_216327_);

    private static RandomSource getRandom() {
        return RANDOM_THREAD_LOCAL.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithSeed(long seed, Runnable action) {
        RandomSource previous = RANDOM_THREAD_LOCAL.get();
        try {
            RANDOM_THREAD_LOCAL.set(RandomSource.m_216335_((long)seed));
            action.run();
        }
        finally {
            RANDOM_THREAD_LOCAL.set(previous);
        }
    }

    @SubscribeEvent
    public static void onBulletHurtPre(EntityHurtByGunEvent.Pre event) {
        DeflectionProfile baseProfile;
        float frac;
        IDeflectionMaterial m;
        Entity target = event.getHurtEntity();
        Level level = target.m_9236_();
        if (!(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        ItemStack blocking = BulletDeflectionHandler.getActiveBlockingItem(player);
        if (blocking.m_41619_()) {
            return;
        }
        Item item = blocking.m_41720_();
        IDeflectionMaterial mat = item instanceof IDeflectionMaterial ? (m = (IDeflectionMaterial)item) : null;
        LivingEntity attackerEntity = event.getAttacker();
        if (!(attackerEntity instanceof LivingEntity)) {
            Biohazardchanges.LOGGER.warn("Attacker is not a LivingEntity, cannot calculate deflection direction.");
            return;
        }
        LivingEntity attacker = attackerEntity;
        Vec3 bodyForward = BulletDeflectionHandler.getPlayerBodyForward(player);
        Vec3 attackerEyePos = attacker.m_146892_();
        Vec3 incomingDirection = player.m_146892_().m_82546_(attackerEyePos).m_82541_();
        double dotProduct = bodyForward.m_82526_(incomingDirection);
        if (dotProduct >= 0.0) {
            Biohazardchanges.LOGGER.debug("Bullet deflection failed: Incoming direction dot product {} >= 0 (not from front)", (Object)dotProduct);
            return;
        }
        float max = blocking.m_41776_();
        float f = frac = max > 0.0f ? (max - (float)blocking.m_41773_()) / max : 1.0f;
        if (mat != null) {
            baseProfile = mat.getDeflectionProfile(blocking);
        } else if (blocking.m_41720_() instanceof ShieldItem) {
            baseProfile = DeflectionProfileBuilder.create().chances(0.35f, 0.45f, 0.2f).deflectConeDeg(22.0f).ricochetConeDeg(38.0f).spallConeDeg(32.0f).spallCount(8).speedMultiplierRange(0.5f, 0.85f).bluntFractions(0.1f, 0.12f, 0.2f).knockbackPerDamage(0.02f).durabilityPerDamage(0.5f).build();
        } else {
            return;
        }
        DeflectionProfile profile = baseProfile.interpolateByDurability(frac);
        Vec3 surfaceNormal = mat != null ? mat.getImpactNormal(bodyForward, blocking, incomingDirection, player) : bodyForward;
        BallisticOutcome outcome = BallisticsResolver.resolve(BulletDeflectionHandler.getRandom(), incomingDirection, surfaceNormal, profile);
        switch (outcome.type) {
            case PENETRATE: {
                break;
            }
            case DEFLECT: 
            case RICOCHET: {
                event.setCanceled(true);
                level.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.TARGET_HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                Vec3 outDir = outcome.outgoingDirection;
                Vec3 impactPos = BulletDeflectionHandler.computeImpactPoint(player, bodyForward, surfaceNormal, event.getBullet(), incomingDirection);
                double frontOffset = mat != null ? mat.getParticleFrontOffset(blocking) : 0.25;
                Vec3 particleSpawnPos = impactPos.m_82549_(outDir.m_82490_(frontOffset));
                float direction = outcome.type == BallisticOutcome.Type.DEFLECT ? profile.deflectConeRad() : profile.ricochetConeRad();
                NetworkHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(particleSpawnPos.f_82479_, particleSpawnPos.f_82480_, particleSpawnPos.f_82481_, 64.0, level.m_46472_())), (Object)new S2CSpawnParticlesPacket(S2CSpawnParticlesPacket.Kind.SPARK_CONE, BulletDeflectionHandler.getRandom().m_188505_(), particleSpawnPos.f_82479_, particleSpawnPos.f_82480_ - 0.2, particleSpawnPos.f_82481_, outDir.f_82479_, outDir.f_82480_, outDir.f_82481_, direction, 0.6f, 70));
                Vec3 backOut = outDir.m_82548_();
                NetworkHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(particleSpawnPos.f_82479_, particleSpawnPos.f_82480_, particleSpawnPos.f_82481_, 64.0, level.m_46472_())), (Object)new S2CSpawnParticlesPacket(S2CSpawnParticlesPacket.Kind.SMOKE_CONE, BulletDeflectionHandler.getRandom().m_188505_(), particleSpawnPos.f_82479_, particleSpawnPos.f_82480_, particleSpawnPos.f_82481_, backOut.f_82479_, backOut.f_82480_, backOut.f_82481_, direction * 0.75f, 0.3f, 18));
                BulletDeflectionHandler.applyBluntFeedback(player, incomingDirection, profile, blocking, event, outcome.type);
                if (level.f_46443_) break;
                double speed = 4.0 * outcome.outgoingSpeedMultiplier;
                BulletDeflectionHandler.spawnDeflectedBullet(player, attacker, event, impactPos, outDir, speed);
                break;
            }
            case SPALL: {
                event.setCanceled(true);
                Vec3 backDir = surfaceNormal.m_82490_(-1.0);
                Vec3 impactPos = BulletDeflectionHandler.computeImpactPoint(player, bodyForward, surfaceNormal, event.getBullet(), incomingDirection);
                double backOffset = mat != null ? mat.getParticleBackOffset(blocking) : 0.25;
                Vec3 particleSpawnPos = impactPos.m_82549_(backDir.m_82490_(backOffset));
                NetworkHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(particleSpawnPos.f_82479_, particleSpawnPos.f_82480_, particleSpawnPos.f_82481_, 64.0, level.m_46472_())), (Object)new S2CSpawnParticlesPacket(S2CSpawnParticlesPacket.Kind.SPARK_CONE, BulletDeflectionHandler.getRandom().m_188505_(), particleSpawnPos.f_82479_, particleSpawnPos.f_82480_ - 0.1, particleSpawnPos.f_82481_, backDir.f_82479_, backDir.f_82480_, backDir.f_82481_, profile.spallConeRad(), 0.4f, Math.max(4, profile.spallCount())));
                BulletDeflectionHandler.applyBluntFeedback(player, incomingDirection, profile, blocking, event, BallisticOutcome.Type.SPALL);
                break;
            }
        }
    }

    private static void spawnDeflectedBullet(Player player, LivingEntity attacker, EntityHurtByGunEvent.Pre event, Vec3 spawnPos, Vec3 outDir, double speed) {
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            Biohazardchanges.LOGGER.warn("Attempted to spawn deflected bullet on client side!");
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack gunItem = attacker.m_21205_();
        if (!(gunItem.m_41720_() instanceof ModernKineticGunItem)) {
            Biohazardchanges.LOGGER.warn("Attacker was not holding a recognized TacZ gun item during deflection.");
            return;
        }
        ResourceLocation gunId = event.getGunId();
        if (gunId == null || gunId.equals((Object)DefaultAssets.EMPTY_GUN_ID)) {
            Biohazardchanges.LOGGER.warn("Bullet gunId is null or empty during deflection.");
            return;
        }
        Optional gunIndexOpt = TimelessAPI.getCommonGunIndex((ResourceLocation)gunId);
        if (gunIndexOpt.isEmpty()) {
            Biohazardchanges.LOGGER.error("Could not find gun index for Gun ID: {}", (Object)gunId);
            return;
        }
        CommonGunIndex gunIndex = (CommonGunIndex)gunIndexOpt.get();
        GunData gunData = gunIndex.getGunData();
        BulletData bulletData = gunIndex.getBulletData();
        if (gunData == null || bulletData == null) {
            Biohazardchanges.LOGGER.error("GunData or BulletData is null for Gun ID: {}", (Object)gunId);
            return;
        }
        ResourceLocation ammoId = gunData.getAmmoId();
        if (ammoId == null) {
            Biohazardchanges.LOGGER.error("Ammo ID is null for Gun ID: {}. Cannot spawn deflected bullet.", (Object)gunId);
            return;
        }
        Vec3 lookDirection = outDir.m_82541_();
        double spreadX = (BulletDeflectionHandler.getRandom().m_188500_() - 0.5) * 0.15;
        double spreadY = (BulletDeflectionHandler.getRandom().m_188500_() - 0.5) * 0.15;
        double spreadZ = (BulletDeflectionHandler.getRandom().m_188500_() - 0.5) * 0.15;
        Vec3 spreadDirection = lookDirection.m_82520_(spreadX, spreadY, spreadZ).m_82541_();
        Vec3 newVelocity = spreadDirection.m_82490_(speed);
        EntityKineticBullet deflectedBullet = new EntityKineticBullet(level, attacker, gunItem, ammoId, gunId, true, gunData, bulletData);
        deflectedBullet.m_5602_((Entity)player);
        deflectedBullet.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_ - 0.2, spawnPos.f_82481_);
        deflectedBullet.m_20256_(newVelocity);
        serverLevel.m_7967_((Entity)deflectedBullet);
        Biohazardchanges.LOGGER.debug("Spawned deflected bullet owned by {} at {} with velocity {} based on original Gun ID {}", (Object)player.m_7755_().getString(), (Object)spawnPos, (Object)newVelocity, (Object)gunId);
    }

    private static ItemStack getActiveBlockingItem(Player player) {
        if (!player.m_21254_()) {
            return ItemStack.f_41583_;
        }
        ItemStack use = player.m_21211_();
        if (use != null && !use.m_41619_()) {
            return use;
        }
        if (player.m_21206_() != null && !player.m_21206_().m_41619_()) {
            return player.m_21206_();
        }
        if (player.m_21205_() != null && !player.m_21205_().m_41619_()) {
            return player.m_21205_();
        }
        return ItemStack.f_41583_;
    }

    private static Vec3 getPlayerBodyForward(Player player) {
        float yawDeg = player.f_20883_;
        double yawRad = Math.toRadians(yawDeg);
        double x = -Math.sin(yawRad);
        double z = Math.cos(yawRad);
        return new Vec3(x, 0.0, z).m_82541_();
    }

    private static Vec3 getShieldCenter(Player player, Vec3 bodyForward) {
        double d;
        Vec3 origin = new Vec3(player.m_20185_(), player.m_20188_() - 0.4, player.m_20189_());
        ItemStack active = BulletDeflectionHandler.getActiveBlockingItem(player);
        Item item = active.m_41720_();
        if (item instanceof IDeflectionMaterial) {
            IDeflectionMaterial m = (IDeflectionMaterial)item;
            d = m.getShieldForwardOffset(active);
        } else {
            d = 0.6;
        }
        double forward = d;
        return origin.m_82549_(bodyForward.m_82490_(forward));
    }

    private static Vec3 computeImpactPoint(Player player, Vec3 bodyForward, Vec3 surfaceNormal, Entity bullet, Vec3 incomingDir) {
        Vec3 hit;
        Vec3 d;
        Vec3 bulletPos = bullet != null ? bullet.m_20182_() : player.m_146892_();
        Vec3 shieldCenter = BulletDeflectionHandler.getShieldCenter(player, bodyForward);
        Vec3 n = surfaceNormal.m_82541_();
        double denom = n.m_82526_(d = incomingDir.m_82541_());
        if (Math.abs(denom) > 1.0E-4) {
            double t = n.m_82526_(shieldCenter.m_82546_(bulletPos)) / denom;
            if (t < 0.0) {
                t = 0.0;
            }
            hit = bulletPos.m_82549_(d.m_82490_(t));
        } else {
            hit = shieldCenter;
        }
        double minY = player.m_20188_() - 1.0;
        double maxY = player.m_20188_() + 1.0;
        double y = Math.max(minY, Math.min(maxY, hit.f_82480_));
        return new Vec3(hit.f_82479_, y, hit.f_82481_);
    }

    private static void applyBluntFeedback(Player player, Vec3 incomingDir, DeflectionProfile profile, ItemStack blocking, EntityHurtByGunEvent.Pre event, BallisticOutcome.Type outcomeType) {
        float incomingDamage = event.getBaseAmount();
        float bluntDamage = Math.max(0.0f, incomingDamage * (switch (outcomeType) {
            case BallisticOutcome.Type.DEFLECT -> profile.bluntFracDeflect();
            case BallisticOutcome.Type.RICOCHET -> profile.bluntFracRicochet();
            case BallisticOutcome.Type.SPALL -> profile.bluntFracSpall();
            default -> profile.bluntFracDeflect();
        }));
        if (bluntDamage > 0.0f) {
            player.m_6469_(player.m_269291_().m_269264_(), bluntDamage);
            double desired = Math.max(0.0, (double)(profile.knockbackPerDamage() * incomingDamage));
            double scaledMag = 0.2 * (1.0 - Math.exp(-0.05 * desired / 0.200001));
            Vec3 push = incomingDir.m_82541_().m_82490_(scaledMag);
            player.m_5997_(push.f_82479_, push.f_82480_ * 0.05, push.f_82481_);
        }
        int dura = Math.max(1, Math.round(profile.durabilityPerDamage() * incomingDamage));
        blocking.m_41622_(dura, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
    }
}

