/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.events;

import com.radar.biohazardchanges.Config;
import com.radar.biohazardchanges.common.explore.ExplorationPool;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ExplorationEvents {
    private static final ResourceKey<Registry<Structure>> STRUCTURE_REG_KEY = Registries.f_256944_;
    private static List<Holder<Structure>> CACHED_WHITELIST = List.of();

    private static List<Holder<Structure>> getWhitelistHolders(ServerLevel level) {
        if (CACHED_WHITELIST.isEmpty()) {
            Registry reg = level.m_9598_().m_175515_(STRUCTURE_REG_KEY);
            List wl = (List)Config.LOCATOR_WHITELIST.get();
            ArrayList list = new ArrayList();
            for (Object idObj : wl) {
                String idStr = (String)idObj;
                ResourceKey key = ResourceKey.m_135785_(STRUCTURE_REG_KEY, (ResourceLocation)ResourceLocation.m_135820_((String)idStr));
                reg.m_203636_(key).ifPresent(list::add);
            }
            CACHED_WHITELIST = List.copyOf(list);
        }
        return CACHED_WHITELIST;
    }

    public static void invalidateWhitelistCache() {
        CACHED_WHITELIST = List.of();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().m_5776_()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        ServerLevel level = player.m_284548_();
        StructureManager structManager = level.m_215010_();
        List<Holder<Structure>> holders = ExplorationEvents.getWhitelistHolders(level);
        if (holders.isEmpty()) {
            return;
        }
        BlockPos pos = player.m_20183_();
        for (Holder<Structure> holder : holders) {
            StructureStart start = structManager.m_220524_(pos, (Structure)holder.m_203334_());
            if (start == null || !start.m_73603_()) continue;
            BoundingBox box = start.m_73601_();
            BlockPos ref = new BlockPos((box.m_162395_() + box.m_162399_()) / 2, box.m_162396_(), (box.m_162398_() + box.m_162401_()) / 2);
            ExplorationPool.markVisit((Level)level, ((ResourceKey)holder.m_203543_().orElseThrow()).m_135782_(), ref, player);
        }
    }

    @SubscribeEvent
    public static void onChestOpen(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (!(state.m_60734_() instanceof ChestBlock)) {
            return;
        }
        ServerLevel level = player2.m_284548_();
        List<Holder<Structure>> holders = ExplorationEvents.getWhitelistHolders(level);
        if (holders.isEmpty()) {
            return;
        }
        BlockPos pos = event.getPos();
        StructureManager structManager = level.m_215010_();
        for (Holder<Structure> holder : holders) {
            StructureStart start = structManager.m_220524_(pos, (Structure)holder.m_203334_());
            if (start == null || !start.m_73603_()) continue;
            BoundingBox box = start.m_73601_();
            BlockPos ref = new BlockPos((box.m_162395_() + box.m_162399_()) / 2, box.m_162396_(), (box.m_162398_() + box.m_162401_()) / 2);
            ExplorationPool.markChestOpened((Level)level, ((ResourceKey)holder.m_203543_().orElseThrow()).m_135782_(), ref, player2);
            break;
        }
    }
}

