/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.events;

import com.radar.biohazardchanges.common.items.shield.RiotShieldItem;
import com.radar.biohazardchanges.common.items.shield.WedgeShieldItem;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="biohazardchanges")
public final class ServerEvents {
    private static final float BASH_KNOCKBACK = 0.5f;
    private static final double BASH_RANGE = 2.5;
    private static final double BASH_WIDTH = 1.5;
    private static final int BASH_COOLDOWN_TICKS = 40;

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        Player player;
        block6: {
            block5: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block5;
                player = (Player)livingEntity;
                if (!event.isCanceled()) break block6;
            }
            return;
        }
        Entity entity = event.getSource().m_7640_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        if (player.m_21254_() && player.m_21211_().m_41720_() instanceof WedgeShieldItem && attacker.m_213824_()) {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12346_, player.m_5720_(), 1.0f, 1.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player.m_6117_() && player.m_21211_().m_41720_() instanceof RiotShieldItem) {
            event.setCanceled(true);
            if (player.m_36335_().m_41519_(player.m_21211_().m_41720_())) {
                return;
            }
            player.m_36335_().m_41524_(player.m_21211_().m_41720_(), 40);
            Vec3 lookVec = player.m_20154_();
            Vec3 startPos = player.m_146892_();
            Vec3 endPos = startPos.m_82520_(lookVec.f_82479_ * 2.5, lookVec.f_82480_ * 2.5, lookVec.f_82481_ * 2.5);
            AABB bashArea = new AABB(startPos, endPos).m_82377_(1.5, 0.25, 1.5);
            List hitEntities = player.m_9236_().m_6443_(LivingEntity.class, bashArea, entity -> entity.m_6084_() && entity != player);
            for (LivingEntity victim : hitEntities) {
                double dX = victim.m_20185_() - player.m_20185_();
                double dZ = victim.m_20189_() - player.m_20189_();
                victim.m_147240_(0.5, dX, dZ);
            }
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 0.8f);
            player.m_21211_().m_41622_(2, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
        }
    }
}

