/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.explore;

import com.radar.biohazardchanges.common.explore.ExplorationSavedData;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class ExplorationPool {
    public static void markVisit(Level level, ResourceLocation id, BlockPos structurePos, ServerPlayer player) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ExplorationSavedData data = ExplorationSavedData.get(serverLevel);
        data.markVisit(id, structurePos, player.m_20148_());
    }

    public static void markChestOpened(Level level, ResourceLocation id, BlockPos structurePos, ServerPlayer player) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ExplorationSavedData data = ExplorationSavedData.get(serverLevel);
        data.markChestOpened(id, structurePos, player.m_20148_());
    }

    public static Optional<VisitInfo> get(Level level, ResourceLocation id, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return Optional.empty();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ExplorationSavedData data = ExplorationSavedData.get(serverLevel);
        return data.get(id, pos);
    }

    public static List<VisitInfo> query(Level level, ResourceLocation id, boolean unexplored, boolean explored, UUID filterPlayer) {
        if (!(level instanceof ServerLevel)) {
            return List.of();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ExplorationSavedData data = ExplorationSavedData.get(serverLevel);
        return data.query(id, unexplored, explored, filterPlayer);
    }

    public static class VisitInfo {
        public final ResourceLocation structureId;
        public final BlockPos structurePos;
        public final UUID firstVisitor;
        public final Set<UUID> visitors = new HashSet<UUID>();
        public boolean chestOpened;

        public VisitInfo(ResourceLocation id, BlockPos pos, UUID first) {
            this.structureId = id;
            this.structurePos = pos;
            this.firstVisitor = first;
            this.visitors.add(first);
        }

        public boolean explored() {
            return this.chestOpened;
        }

        public boolean exploredBy(UUID player) {
            return this.chestOpened && this.visitors.contains(player);
        }
    }
}

