/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.explore;

import com.radar.biohazardchanges.common.explore.ExplorationPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class ExplorationSavedData
extends SavedData {
    private static final String DATA_NAME = "biohazard_exploration";
    private final Map<ResourceLocation, Map<BlockPos, Entry>> dataByStructure = new HashMap<ResourceLocation, Map<BlockPos, Entry>>();

    public static ExplorationSavedData get(ServerLevel level) {
        return (ExplorationSavedData)level.m_8895_().m_164861_(ExplorationSavedData::load, ExplorationSavedData::new, DATA_NAME);
    }

    public static ExplorationSavedData load(CompoundTag tag) {
        ExplorationSavedData data = new ExplorationSavedData();
        ListTag outer = tag.m_128437_("structures", 10);
        for (int i = 0; i < outer.size(); ++i) {
            CompoundTag structTag = outer.m_128728_(i);
            ResourceLocation id = ResourceLocation.parse((String)structTag.m_128461_("id"));
            ListTag entries = structTag.m_128437_("entries", 10);
            HashMap<BlockPos, Entry> map = new HashMap<BlockPos, Entry>();
            for (int j = 0; j < entries.size(); ++j) {
                CompoundTag e = entries.m_128728_(j);
                BlockPos pos = BlockPos.m_122022_((long)e.m_128454_("pos"));
                UUID first = e.m_128403_("first") ? e.m_128342_("first") : null;
                boolean opened = e.m_128471_("opened");
                HashSet<UUID> visitors = new HashSet<UUID>();
                ListTag visList = e.m_128437_("visitors", 8);
                for (int k = 0; k < visList.size(); ++k) {
                    visitors.add(UUID.fromString(visList.m_128778_(k)));
                }
                map.put(pos, new Entry(id, pos, first, opened, visitors));
            }
            data.dataByStructure.put(id, map);
        }
        return data;
    }

    private static ExplorationPool.VisitInfo toVisitInfo(Entry e) {
        ExplorationPool.VisitInfo vi = new ExplorationPool.VisitInfo(e.structureId, e.structurePos, e.firstVisitor == null ? new UUID(0L, 0L) : e.firstVisitor);
        vi.chestOpened = e.chestOpened;
        vi.visitors.addAll(e.visitors);
        return vi;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag outer = new ListTag();
        for (Map.Entry<ResourceLocation, Map<BlockPos, Entry>> byId : this.dataByStructure.entrySet()) {
            CompoundTag structTag = new CompoundTag();
            structTag.m_128359_("id", byId.getKey().toString());
            ListTag entries = new ListTag();
            for (Entry e : byId.getValue().values()) {
                CompoundTag ct = new CompoundTag();
                ct.m_128356_("pos", e.structurePos.m_121878_());
                if (e.firstVisitor != null) {
                    ct.m_128362_("first", e.firstVisitor);
                }
                ct.m_128379_("opened", e.chestOpened);
                ListTag vis = new ListTag();
                for (UUID u : e.visitors) {
                    vis.add((Object)StringTag.m_129297_((String)u.toString()));
                }
                ct.m_128365_("visitors", (Tag)vis);
                entries.add((Object)ct);
            }
            structTag.m_128365_("entries", (Tag)entries);
            outer.add((Object)structTag);
        }
        tag.m_128365_("structures", (Tag)outer);
        return tag;
    }

    public void markVisit(ResourceLocation id, BlockPos pos, UUID player) {
        Map map = this.dataByStructure.computeIfAbsent(id, k -> new HashMap());
        Entry entry = map.computeIfAbsent(pos, p -> new Entry(id, pos, player, false, new HashSet<UUID>()));
        entry.visitors.add(player);
        this.m_77762_();
    }

    public void markChestOpened(ResourceLocation id, BlockPos pos, UUID player) {
        Map map = this.dataByStructure.computeIfAbsent(id, k -> new HashMap());
        Entry entry = map.computeIfAbsent(pos, p -> new Entry(id, pos, player, false, new HashSet<UUID>()));
        entry.chestOpened = true;
        entry.visitors.add(player);
        this.m_77762_();
    }

    public Optional<ExplorationPool.VisitInfo> get(ResourceLocation id, BlockPos pos) {
        Map<BlockPos, Entry> byId = this.dataByStructure.get(id);
        if (byId == null) {
            return Optional.empty();
        }
        Entry e = byId.get(pos);
        if (e == null) {
            return Optional.empty();
        }
        return Optional.of(ExplorationSavedData.toVisitInfo(e));
    }

    public List<ExplorationPool.VisitInfo> query(ResourceLocation id, boolean wantUnexplored, boolean wantExplored, UUID filter) {
        Map byId = this.dataByStructure.getOrDefault(id, Map.of());
        ArrayList<ExplorationPool.VisitInfo> out = new ArrayList<ExplorationPool.VisitInfo>();
        for (Entry e : byId.values()) {
            boolean include;
            boolean explored = e.chestOpened;
            boolean bl = include = wantUnexplored && !explored || wantExplored && explored;
            if (include && filter != null) {
                include = e.visitors.contains(filter);
            }
            if (!include) continue;
            out.add(ExplorationSavedData.toVisitInfo(e));
        }
        return out;
    }

    private static class Entry {
        final ResourceLocation structureId;
        final BlockPos structurePos;
        final UUID firstVisitor;
        final Set<UUID> visitors;
        boolean chestOpened;

        Entry(ResourceLocation id, BlockPos pos, UUID first, boolean opened, Set<UUID> visitors) {
            this.structureId = id;
            this.structurePos = pos;
            this.firstVisitor = first;
            this.chestOpened = opened;
            this.visitors = visitors;
        }
    }
}

