/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.items;

import com.radar.biohazardchanges.client.card.CardBuilder;
import com.radar.biohazardchanges.client.card.CardData;
import com.radar.biohazardchanges.client.card.CardSide;
import com.radar.biohazardchanges.client.card.PlayerFaceElement;
import com.radar.biohazardchanges.client.card.ReverseTextElement;
import com.radar.biohazardchanges.client.card.TextElement;
import com.radar.biohazardchanges.client.screen.CardScreenBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class IDCardItem
extends Item {
    private static boolean bound = false;
    private static String playerName = "";

    public IDCardItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.openEnhancedIDScreen(player));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (level != null && level.f_46443_) {
            if (bound) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.biohazardchanges.idcard.bound", (Object[])new Object[]{playerName, this.getSurvivorID(playerName)}));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.biohazardchanges.idcard.unbound"));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.biohazardchanges.idcard.examine"));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }

    private int getSurvivorID(String name) {
        return Math.abs(name.hashCode() % 10000);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openEnhancedIDScreen(Player player) {
        CardData cardData = this.createPlayerIDCard(player);
        CardScreenBase screen = new CardScreenBase((Component)Component.m_237115_((String)"item.biohazardchanges.id_card"), cardData, 200, 300);
        this.addCardInfoPanel(screen, player);
        playerName = player.m_7755_().getString();
        bound = true;
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    @OnlyIn(value=Dist.CLIENT)
    private CardData createPlayerIDCard(Player player) {
        CardBuilder builder = new CardBuilder();
        builder.setFrontTexture(new ResourceLocation("biohazardchanges", "textures/gui/id_card_gui.png"));
        builder.setBackTexture(new ResourceLocation("biohazardchanges", "textures/gui/id_card_gui_back.png"));
        builder.addElement(new TextElement(CardSide.FRONT, (Component)Component.m_237113_((String)player.m_7755_().getString()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))), 10.0f, 60.0f, 0.0f, 0, false));
        ResourceLocation skinTexture = Minecraft.m_91087_().m_91109_().m_240306_(player.m_36316_());
        builder.addElement(new PlayerFaceElement(CardSide.FRONT, skinTexture, 100, 80, 0, 64));
        int idNumber = this.getSurvivorID(player.m_7755_().getString());
        builder.addElement(new TextElement(CardSide.FRONT, (Component)Component.m_237113_((String)("ID: " + idNumber)), 10.0f, 80.0f, 0.0f, 0, false));
        builder.addElement(new ReverseTextElement(CardSide.BACK, (Component)Component.m_237113_((String)"AUTHORIZED PERSONNEL"), 50.0f, 50.0f, 0.0f, 0xFF0000, true));
        return builder.build();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addCardInfoPanel(CardScreenBase screen, Player player) {
        MutableComponent infoText = Component.m_237113_((String)"Survivor Identification").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(0xFFFFFF)).m_7220_((Component)Component.m_237113_((String)"\n\n"));
        infoText.m_7220_((Component)Component.m_237113_((String)"Name: ").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)player.m_7755_().getString())).m_7220_((Component)Component.m_237113_((String)"\n\n"));
        int idNumber = this.getSurvivorID(player.m_7755_().getString());
        infoText.m_7220_((Component)Component.m_237113_((String)"ID Number: ").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)String.valueOf(idNumber))).m_7220_((Component)Component.m_237113_((String)"\n\n"));
        String clearance = switch (idNumber % 4) {
            case 0 -> "Alpha";
            case 1 -> "Beta";
            case 2 -> "Gamma";
            default -> "Delta";
        };
        infoText.m_7220_((Component)Component.m_237113_((String)"Clearance Level: ").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)clearance).m_130948_(Style.f_131099_.m_178520_(65280))).m_7220_((Component)Component.m_237113_((String)"\n\n"));
        infoText.m_7220_((Component)Component.m_237113_((String)"Controls:").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)))).m_7220_((Component)Component.m_237113_((String)"\n\u2022 SPACE to flip the card")).m_7220_((Component)Component.m_237113_((String)"\n\u2022 Click and drag to rotate"));
        screen.addInfoPanelWithBackground((Component)infoText, screen.f_96543_ * 2 / 3, 50, 0xFFFFFF, true, 250, 1.1f, Integer.MIN_VALUE, 12);
    }
}

