/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.items.shield;

import com.radar.biohazardchanges.common.ballistics.DeflectionProfile;
import com.radar.biohazardchanges.common.ballistics.DeflectionProfileBuilder;
import com.radar.biohazardchanges.common.ballistics.IDeflectionMaterial;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WedgeShieldItem
extends ShieldItem
implements IDeflectionMaterial {
    public WedgeShieldItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!pLevel.m_5776_() && pEntity instanceof Player) {
            boolean inOffHand;
            Player player = (Player)pEntity;
            boolean inMainHand = player.m_21205_() == pStack;
            boolean bl = inOffHand = player.m_21206_() == pStack;
            if (inMainHand || inOffHand) {
                boolean otherHandOccupied = inMainHand ? !player.m_21206_().m_41619_() : !player.m_21205_().m_41619_();
                int slownessAmplifier = otherHandOccupied ? 1 : 0;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, slownessAmplifier, true, false));
            }
        }
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    @Override
    public DeflectionProfile getDeflectionProfile(ItemStack stack) {
        return DeflectionProfileBuilder.create().chances(0.7f, 0.25f, 0.05f).deflectConeDeg(12.0f).ricochetConeDeg(28.0f).spallConeDeg(25.0f).spallCount(6).speedMultiplierRange(0.6f, 0.95f).bluntFractions(0.03f, 0.08f, 0.12f).knockbackPerDamage(0.025f).durabilityPerDamage(0.35f).build();
    }

    @Override
    public Vec3 getImpactNormal(Vec3 playerLookNormal, ItemStack stack, Vec3 incomingDirection, Player player) {
        Vec3 up;
        Vec3 look = playerLookNormal.m_82541_();
        Vec3 right = look.m_82537_(up = new Vec3(0.0, 1.0, 0.0)).m_82541_();
        if (right.m_82556_() == 0.0) {
            right = new Vec3(1.0, 0.0, 0.0);
        }
        up = right.m_82537_(look).m_82541_();
        Vec3 incoming = incomingDirection.m_82541_();
        double side = right.m_82526_(incoming);
        double wedgeHalfAngleDeg = 35.0;
        double wedgeHalfAngleRad = Math.toRadians(wedgeHalfAngleDeg);
        double eyeY = player.m_20188_();
        double hitY = eyeY;
        double dy = Math.abs(hitY - eyeY);
        double heightFactor = dy <= 1.0 ? 1.0 : Math.max(0.0, 1.0 - (dy - 1.0));
        Vec3 lateral = side >= 0.0 ? right.m_82490_(-1.0) : right;
        Vec3 faceDir = look.m_82490_(Math.cos(wedgeHalfAngleRad)).m_82549_(lateral.m_82490_(Math.sin(wedgeHalfAngleRad)));
        double blend = heightFactor;
        Vec3 normal = faceDir.m_82541_().m_82490_(blend).m_82549_(look.m_82490_(1.0 - blend));
        return normal.m_82541_();
    }

    @Override
    public double getShieldForwardOffset(ItemStack stack) {
        return 0.6;
    }

    @Override
    public double getParticleFrontOffset(ItemStack stack) {
        return 0.35;
    }

    @Override
    public double getParticleBackOffset(ItemStack stack) {
        return 0.3;
    }
}

