/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.locate;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class AsyncLocatorService {
    private static ExecutorService EXECUTOR;

    private AsyncLocatorService() {
    }

    public static void setup() {
        AsyncLocatorService.shutdown();
        EXECUTOR = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    }

    public static void shutdown() {
        if (EXECUTOR != null) {
            EXECUTOR.shutdownNow();
            EXECUTOR = null;
        }
    }

    public static CompletableFuture<Pair<BlockPos, Holder<Structure>>> locate(ServerLevel level, ResourceLocation structureId, BlockPos origin, int radius, boolean skipExisting) {
        return CompletableFuture.supplyAsync(() -> AsyncLocatorService.doLocate(level, structureId, origin, radius, skipExisting), EXECUTOR);
    }

    private static Pair<BlockPos, Holder<Structure>> doLocate(ServerLevel level, ResourceLocation structureId, BlockPos origin, int radius, boolean skipExisting) {
        ResourceKey key;
        Registry reg = level.m_9598_().m_175515_(Registries.f_256944_);
        Optional holderOpt = reg.m_203636_(key = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)structureId));
        if (holderOpt.isEmpty()) {
            return null;
        }
        Holder holder = (Holder)holderOpt.get();
        HolderSet.Direct set = HolderSet.m_205809_((Holder[])new Holder[]{holder});
        return level.m_7726_().m_8481_().m_223037_(level, (HolderSet)set, origin, radius, skipExisting);
    }
}

