/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.locate;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public final class StructureEnergyRegistry {
    private static final Map<ResourceLocation, EnergySpec> ENERGIES = new HashMap<ResourceLocation, EnergySpec>();

    private StructureEnergyRegistry() {
    }

    public static void register(String namespace, String path, EnergySpec spec) {
        ENERGIES.put(new ResourceLocation(namespace, path), spec);
    }

    public static EnergySpec get(ResourceLocation id) {
        EnergySpec spec = ENERGIES.get(id);
        if (spec == null) {
            spec = new EnergySpec(2000, 20, 2048);
        }
        return spec;
    }

    static {
        StructureEnergyRegistry.register("minecraft", "village_plains", new EnergySpec(2000, 20, 2048));
        StructureEnergyRegistry.register("minecraft", "mansion", new EnergySpec(10000, 50, 4096));
        StructureEnergyRegistry.register("minecraft", "stronghold", new EnergySpec(8000, 40, 4096));
        StructureEnergyRegistry.register("minecraft", "bastion_remnant", new EnergySpec(6000, 30, 4096));
    }

    public record EnergySpec(int startCost, int sustainCostPerTick, int defaultRadius) {
    }
}

