/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.network;

import com.radar.biohazardchanges.common.blocks.blockentity.ConsoleBE;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public record C2SConsoleSearchPacket(BlockPos consolePos, ResourceLocation structureTag, int radius, int selectedIndex, boolean findUnexplored) {
    public static void encode(C2SConsoleSearchPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.consolePos);
        buf.m_130085_(msg.structureTag);
        buf.m_130130_(msg.radius);
        buf.m_130130_(msg.selectedIndex);
        buf.writeBoolean(msg.findUnexplored);
    }

    public static C2SConsoleSearchPacket decode(FriendlyByteBuf buf) {
        return new C2SConsoleSearchPacket(buf.m_130135_(), buf.m_130281_(), buf.m_130242_(), buf.m_130242_(), buf.readBoolean());
    }

    public static void handle(C2SConsoleSearchPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            BlockEntity be = level.m_7702_(msg.consolePos);
            if (be instanceof ConsoleBE) {
                boolean consoleHasPower;
                ConsoleBE console = (ConsoleBE)be;
                boolean bl = consoleHasPower = console.getEnergyStorage().getEnergyStored() > 0;
                if (!console.isAntennaPowered() || !consoleHasPower) {
                    if (console.isSearching()) {
                        console.cancelSearch();
                    }
                    return;
                }
                if (console.isSearching()) {
                    console.cancelSearch();
                    return;
                }
                console.setSelectedIndex(Math.max(0, msg.selectedIndex));
                console.requestSearch(msg.structureTag, msg.radius, msg.findUnexplored);
                console.refreshLinkNow();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

