/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.network;

import com.radar.biohazardchanges.common.items.shield.RiotShieldItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class C2SShieldBashPacket {
    private static final float BASH_DAMAGE = 4.0f;
    private static final float BASH_KNOCKBACK = 0.5f;
    private static final double BASH_RANGE = 2.5;
    private static final double BASH_WIDTH = 1.5;
    private static final int BASH_COOLDOWN_TICKS = 40;

    public static C2SShieldBashPacket decode(FriendlyByteBuf buf) {
        return new C2SShieldBashPacket();
    }

    public static void encode(C2SShieldBashPacket packet, FriendlyByteBuf buf) {
    }

    public static void handle(C2SShieldBashPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            if (player.m_6117_() && player.m_21211_().m_41720_() instanceof RiotShieldItem) {
                if (player.m_36335_().m_41519_(player.m_21211_().m_41720_())) {
                    return;
                }
                player.m_36335_().m_41524_(player.m_21211_().m_41720_(), 40);
                Vec3 lookVec = player.m_20154_();
                Vec3 startPos = player.m_146892_();
                Vec3 endPos = startPos.m_82520_(lookVec.f_82479_ * 2.5, lookVec.f_82480_ * 2.5, lookVec.f_82481_ * 2.5);
                AABB bashArea = new AABB(startPos, endPos).m_82377_(1.5, 0.25, 1.5);
                List hitEntities = player.m_9236_().m_6443_(LivingEntity.class, bashArea, entity -> entity.m_6084_() && entity != player);
                for (LivingEntity victim : hitEntities) {
                    double dX = victim.m_20185_() - player.m_20185_();
                    double dZ = victim.m_20189_() - player.m_20189_();
                    victim.m_147240_(0.5, -dX, -dZ);
                    victim.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 0, false, false));
                }
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 0.8f);
                player.m_21211_().m_41622_(2, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
            }
        });
        context.setPacketHandled(true);
    }
}

