/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.network;

import com.radar.biohazardchanges.client.handler.ClientPacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class S2CSpawnParticlesPacket {
    private final Kind kind;
    private final long seed;
    private final double x;
    private final double y;
    private final double z;
    private final double dirX;
    private final double dirY;
    private final double dirZ;
    private final float angleRad;
    private final float speed;
    private final int count;

    public S2CSpawnParticlesPacket(Kind kind, long seed, double x, double y, double z, double dirX, double dirY, double dirZ, float angleRad, float speed, int count) {
        this.kind = kind;
        this.seed = seed;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dirX = dirX;
        this.dirY = dirY;
        this.dirZ = dirZ;
        this.angleRad = angleRad;
        this.speed = speed;
        this.count = count;
    }

    public static void encode(S2CSpawnParticlesPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)packet.kind);
        buffer.writeLong(packet.seed);
        buffer.writeDouble(packet.x);
        buffer.writeDouble(packet.y);
        buffer.writeDouble(packet.z);
        buffer.writeDouble(packet.dirX);
        buffer.writeDouble(packet.dirY);
        buffer.writeDouble(packet.dirZ);
        buffer.writeFloat(packet.angleRad);
        buffer.writeFloat(packet.speed);
        buffer.writeInt(packet.count);
    }

    public static S2CSpawnParticlesPacket decode(FriendlyByteBuf buffer) {
        Kind kind = (Kind)buffer.m_130066_(Kind.class);
        long seed = buffer.readLong();
        return new S2CSpawnParticlesPacket(kind, seed, buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readFloat(), buffer.readFloat(), buffer.readInt());
    }

    public static void handle(S2CSpawnParticlesPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientPacketHandler.handleSpawnParticlesPacket(packet));
        context.setPacketHandled(true);
    }

    public Kind getKind() {
        return this.kind;
    }

    public long getSeed() {
        return this.seed;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getDirX() {
        return this.dirX;
    }

    public double getDirY() {
        return this.dirY;
    }

    public double getDirZ() {
        return this.dirZ;
    }

    public float getAngleRad() {
        return this.angleRad;
    }

    public float getSpeed() {
        return this.speed;
    }

    public int getCount() {
        return this.count;
    }

    public static enum Kind {
        SPARK_CONE,
        SMOKE_CONE;

    }
}

