/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.network;

import com.radar.biohazardchanges.common.events.IServerEvent;
import com.radar.biohazardchanges.common.events.ServerEventRegistry;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public record TriggerServerEventPacket(ResourceLocation eventId, Vec3 position, @Nullable CompoundTag extraData) {
    public static void encode(TriggerServerEventPacket msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.eventId);
        buf.writeDouble(msg.position.f_82479_);
        buf.writeDouble(msg.position.f_82480_);
        buf.writeDouble(msg.position.f_82481_);
        buf.m_130079_(msg.extraData);
    }

    public static TriggerServerEventPacket decode(FriendlyByteBuf buf) {
        return new TriggerServerEventPacket(buf.m_130281_(), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.m_130260_());
    }

    public static void handle(TriggerServerEventPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IServerEvent event;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (event = ServerEventRegistry.get(msg.eventId)) != null) {
                event.trigger(player, msg.position, msg.extraData);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

