/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.registry;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BioSounds {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"biohazardchanges");
    public static final RegistryObject<SoundEvent> BUTTON_PRESS = BioSounds.registerSoundEvent("button_press");
    public static final RegistryObject<SoundEvent> BIRTHDAY_POPPER = BioSounds.registerSoundEvent("birthday_popper");
    public static final RegistryObject<SoundEvent> YAY = BioSounds.registerSoundEvent("yay");
    public static final RegistryObject<SoundEvent> FINALE_START = BioSounds.registerSoundEvent("finale_start");
    private static final String MUSIC_PREFIX = "music.track.";
    private static final Map<String, RegistryObject<SoundEvent>> TRACK_MAP = new HashMap<String, RegistryObject<SoundEvent>>();
    public static final RegistryObject<SoundEvent> TRACK_BONUS = BioSounds.registerTrack("bonus_looping");
    public static final RegistryObject<SoundEvent> TRACK_DECAYED = BioSounds.registerTrack("decayed_humanity_looping");
    public static final RegistryObject<SoundEvent> TRACK_ESCAPE = BioSounds.registerTrack("escape_plan_looping");
    public static final RegistryObject<SoundEvent> TRACK_REVISIT = BioSounds.registerTrack("revisting_home_looping");
    public static final RegistryObject<SoundEvent> TRACK_SURVIVOR = BioSounds.registerTrack("survivor_wish_looping");
    public static final RegistryObject<SoundEvent> TRACK_TEMP = BioSounds.registerTrack("temp");

    private static RegistryObject<SoundEvent> registerTrack(String trackName) {
        String id = MUSIC_PREFIX + trackName;
        RegistryObject<SoundEvent> registryObject = BioSounds.registerSoundEvent(id);
        TRACK_MAP.put(trackName, registryObject);
        return registryObject;
    }

    public static RegistryObject<SoundEvent> getTrack(String trackName) {
        return TRACK_MAP.getOrDefault(trackName, TRACK_TEMP);
    }

    private static RegistryObject<SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENTS.register(name, () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("biohazardchanges", name)));
    }

    public static void register(IEventBus eventBus) {
        SOUND_EVENTS.register(eventBus);
    }
}

