#version 150

// Simple screen-space fluid-like update on a RGBA field
// Sampler0: previous state (xy = vector field, zw = auxiliaries)
// Sampler1: noise texture for small perturbations

uniform sampler2D Sampler0;
uniform sampler2D Sampler1;
uniform vec2 OutSize;
uniform float Time;

in vec2 TexCoords;
out vec4 fragColor;

#define _G0 0.25
#define _G1 0.125
#define _G2 0.0625

vec4 gaussian9(vec4 c, vec4 nw, vec4 n, vec4 ne, vec4 w, vec4 e, vec4 sw, vec4 s, vec4 se) {
    return _G0*c + _G1*(n + e + w + s) + _G2*(nw + sw + ne + se);
}

vec2 normz(vec2 x) {
    float l = length(x);
    return l > 1e-6 ? x / l : vec2(0.0);
}

void main() {
    vec2 texel = 1.0 / OutSize;
    vec2 uv = TexCoords;

    // Neighborhood
    vec4 c  = texture(Sampler0, uv);
    vec4 n  = texture(Sampler0, uv + vec2(0.0,  texel.y));
    vec4 s  = texture(Sampler0, uv + vec2(0.0, -texel.y));
    vec4 e  = texture(Sampler0, uv + vec2( texel.x, 0.0));
    vec4 w  = texture(Sampler0, uv + vec2(-texel.x, 0.0));
    vec4 nw = texture(Sampler0, uv + vec2(-texel.x,  texel.y));
    vec4 ne = texture(Sampler0, uv + vec2( texel.x,  texel.y));
    vec4 sw = texture(Sampler0, uv + vec2(-texel.x, -texel.y));
    vec4 se = texture(Sampler0, uv + vec2( texel.x, -texel.y));

    // Smooth current
    vec4 lapl = gaussian9(c, nw, n, ne, w, e, sw, s, se) - c;

    // Advect a bit along the field
    vec2 v = c.xy * 2.0 - 1.0;
    vec2 advUv = uv - v * 0.75 * texel;
    vec4 adv = texture(Sampler0, advUv);

    // Add small noise forcing
    float noise = texture(Sampler1, uv * 2.0 + vec2(Time * 0.11, -Time * 0.07)).r - 0.5;
    vec2 force = vec2(noise, -noise) * 0.05;

    vec2 newV = mix(adv.xy, (adv.xy + lapl.xy) + force, 0.5);
    newV = clamp(newV, 0.0, 1.0);
    vec2 aux = mix(adv.zw, adv.zw + lapl.zw, 0.5);

    fragColor = vec4(newV, aux);
}

