#version 150

uniform sampler2D Sampler0; // fluid state (xy in 0..1 encodes velocity)
uniform float EffectIntensity;
uniform float Time;

in vec2 TexCoords;
out vec4 fragColor;

// Simple spectral mapping from scalar to RGB
vec3 spectral(float x) {
    x = clamp(x, 0.0, 1.0);
    float r = smoothstep(0.5, 0.9, x);
    float g = smoothstep(0.2, 0.8, 1.0 - abs(x - 0.5) * 2.0);
    float b = smoothstep(0.1, 0.5, 1.0 - x);
    return vec3(r, g, b);
}

void main() {
    vec2 v01 = texture(Sampler0, TexCoords).xy;
    vec2 v = v01 * 2.0 - 1.0;
    float m = length(v);

    // Color by velocity magnitude with a subtle animated tint
    vec3 base = spectral(m);
    float pulse = 0.5 + 0.5 * sin(Time * 2.0 + m * 10.0);
    vec3 color = mix(base, vec3(1.0, 0.8, 0.2), 0.15 * pulse);

    float alpha = clamp(m * 1.5, 0.0, 1.0) * clamp(EffectIntensity, 0.0, 1.0);
    fragColor = vec4(color, alpha * 0.35); // gentle overlay
}

