#version 150

uniform sampler2D Sampler0; // current screen copy
uniform sampler2D Sampler1; // previous warped frame (feedback)
uniform sampler2D Sampler2; // noise
uniform float Time;
uniform float EffectIntensity;
uniform vec2 OutSize; // screen size

in vec2 TexCoords;
out vec4 fragColor;

#define SAMPLES 48
#define DISP_SCALE 0.03
#define SIGMOID_CONTRAST 8.0

vec3 contrast(vec3 x) {
    return 1.0 / (1.0 + exp(-SIGMOID_CONTRAST * (x - 0.5)));
}

vec3 sampleWeights(float i) {
    return vec3(i * i, 46.6666*pow((1.0-i)*i,3.0), (1.0 - i) * (1.0 - i));
}

vec3 sampleDispersion(in vec2 uv, in vec2 dir, float disp) {
    vec3 col = vec3(0.0);
    const float SD = 1.0 / float(SAMPLES);
    float wl = 0.0;
    vec3 denom = vec3(0.0);
    for (int i = 0; i < SAMPLES; i++) {
        vec3 w = sampleWeights(wl);
        denom += w;
        col += w * texture(Sampler0, uv + dir * disp * wl).rgb;
        wl += SD;
    }
    return col / denom;
}

void main() {
    float intensity = clamp(EffectIntensity, 0.0, 1.0);
    vec2 uv = TexCoords;

    // Build a smooth time-varying vector field from noise
    vec2 n0 = texture(Sampler2, uv * 1.5 + vec2(Time * 0.02, -Time * 0.015)).rg;
    vec2 n1 = texture(Sampler2, uv * 3.0 + vec2(-Time * 0.017, Time * 0.013)).rg;
    vec2 v = (n0 + n1) - vec2(1.0);
    float lenv = length(v);
    vec2 dir = lenv > 1e-5 ? normalize(v) : vec2(0.0);

    // Chromatic dispersion along dir
    vec3 dispCol = sampleDispersion(uv, dir, DISP_SCALE * (0.5 + 1.5 * lenv) * intensity);
    dispCol = contrast(dispCol);

    // Feedback blend
    vec3 prev = texture(Sampler1, uv).rgb;
    vec3 color = mix(dispCol, prev, 0.12);

    fragColor = vec4(color, 1.0);
}

