#version 150

uniform sampler2D Sampler0; // copy of the screen
uniform float Time;
uniform float EffectIntensity;

in vec2 TexCoords;
out vec4 fragColor;

void main() {
    float t = Time;
    float intensity = clamp(EffectIntensity, 0.0, 1.0);

    // Simple but wild-looking warp
    vec2 uv = TexCoords;
    float w = 0.02 * intensity;
    uv.x += sin((uv.y + t * 0.25) * 40.0) * w;
    uv.y += cos((uv.x - t * 0.18) * 35.0) * w;

    // Slight chromatic dispersion
    float dx = 0.003 * intensity;
    vec3 color;
    color.r = texture(Sampler0, clamp(uv + vec2(+dx, 0.0), 0.0, 1.0)).r;
    color.g = texture(Sampler0, clamp(uv, 0.0, 1.0)).g;
    color.b = texture(Sampler0, clamp(uv + vec2(-dx, 0.0), 0.0, 1.0)).b;

    fragColor = vec4(color, 1.0);
}

