#version 150

uniform sampler2D Sampler0; // vector field (xy in 0..1)
uniform sampler2D Sampler1; // original screen copy
uniform sampler2D Sampler2; // previous frame (feedback)
uniform float EffectIntensity;

in vec2 TexCoords;
out vec4 fragColor;

#define SAMPLES 64
#define SIGMOID_CONTRAST 12.0

vec3 contrast(vec3 x) {
    return 1.0 / (1.0 + exp(-SIGMOID_CONTRAST * (x - 0.5)));
}

vec3 sampleWeights(float i) {
    return vec3(i * i, 46.6666*pow((1.0-i)*i,3.0), (1.0 - i) * (1.0 - i));
}

void main() {
    vec2 uv = TexCoords;
    vec2 v = texture(Sampler0, uv).xy * 2.0 - 1.0;
    float lenv = length(v);
    vec2 dir = lenv > 1e-5 ? normalize(v) : vec2(0.0);

    float t = clamp(EffectIntensity, 0.0, 1.0);
    float e = t * t * (3.0 - 2.0 * t); // smoothstep easing
    float disp = 0.05 * lenv * e;
    vec3 col = vec3(0.0);
    const float SD = 1.0 / float(SAMPLES);
    float wl = 0.0;
    vec3 denom = vec3(0.0);
    for (int i = 0; i < SAMPLES; i++) {
        vec3 w = sampleWeights(wl);
        denom += w;
        col += w * texture(Sampler1, uv + dir * disp * wl).rgb;
        wl += SD;
    }
    col /= denom;
    col = contrast(col);

    // temporal feedback blend for smooth ramp-in/out
    vec3 prev = texture(Sampler2, uv).rgb;
    float feedback = 0.96; // closer to 1.0 = more persistence
    vec3 outCol = mix(col, prev, feedback);

    fragColor = vec4(outCol, 1.0);
}

