#version 150

uniform sampler2D Sampler0; // input: screen copy
uniform vec2 OutSize;       // screen size

in vec2 TexCoords;
out vec4 fragColor;

float luma(vec3 c) {
    return dot(c, vec3(0.299, 0.587, 0.114));
}

void main() {
    vec2 texel = 1.0 / OutSize;
    vec2 uv = TexCoords;

    // 3x3 Sobel
    float tl = luma(texture(Sampler0, uv + texel * vec2(-1.0, -1.0)).rgb);
    float  l = luma(texture(Sampler0, uv + texel * vec2(-1.0,  0.0)).rgb);
    float bl = luma(texture(Sampler0, uv + texel * vec2(-1.0, +1.0)).rgb);
    float  t = luma(texture(Sampler0, uv + texel * vec2( 0.0, -1.0)).rgb);
    float  c = luma(texture(Sampler0, uv).rgb);
    float  b = luma(texture(Sampler0, uv + texel * vec2( 0.0, +1.0)).rgb);
    float tr = luma(texture(Sampler0, uv + texel * vec2(+1.0, -1.0)).rgb);
    float  r = luma(texture(Sampler0, uv + texel * vec2(+1.0,  0.0)).rgb);
    float br = luma(texture(Sampler0, uv + texel * vec2(+1.0, +1.0)).rgb);

    float gx = (tr + 2.0*r + br) - (tl + 2.0*l + bl);
    float gy = (bl + 2.0*b + br) - (tl + 2.0*t + tr);
    vec2 grad = vec2(gx, gy);
    if (length(grad) > 1e-5) grad = normalize(grad);
    // small spatial blur on vector to ease in
    vec2 v0 = grad;
    vec2 v1 = normalize(vec2(
        (tr + 2.0*r + br) - (tl + 2.0*l + bl),
        (bl + 2.0*b + br) - (tl + 2.0*t + tr)
    ));
    vec2 v = mix(v0, v1, 0.4) * 0.5 + 0.5; // map to 0..1

    fragColor = vec4(v, 0.0, 1.0);
}

