#version 150

in vec2 TexCoords;

uniform sampler2D Sampler0; // Base tube texture
uniform sampler2D Sampler1; // Mask for the inner filaments

uniform vec4 ColorModulator;
uniform float GlowIntensity; // Your radiation factor (0.0 to 1.0)
uniform vec4 GlowColor;
uniform float Time;

out vec4 fragColor;

void main() {
    // 1. Base Texture
    vec4 baseColor = texture(Sampler0, TexCoords);

    // 2. Inner Filament Glow
    float filamentMask = texture(Sampler1, TexCoords).r;
    float flicker = 0.7 + (sin(Time * 8.0) * sin(Time * 1.5) * 0.3);
    float innerGlowAmount = pow(filamentMask, 2.0) * GlowIntensity * flicker;
    vec3 innerGlow = GlowColor.rgb * innerGlowAmount;

    // 3. Radial Outer Glow
    float distFromCenter = distance(TexCoords, vec2(0.5, 0.45));
    float radialGlowAmount = smoothstep(0.5, 0.1, distFromCenter);
    vec3 outerGlow = GlowColor.rgb * radialGlowAmount * GlowIntensity * 0.7;

    // 4. Horizontal Scanline Glow
    float scanlineY = 0.4;
    float distFromScanline = abs(TexCoords.y - scanlineY);
    float scanlineAmount = pow(1.0 - distFromScanline, 40.0);

    // THE FIX: Multiply by 'radialGlowAmount' to fade the line's edges.
    scanlineAmount *= (0.6 + sin(Time * 25.0) * 0.4) * GlowIntensity * radialGlowAmount;

    vec3 scanlineGlow = (GlowColor.rgb + vec3(0.6)) * scanlineAmount;

    // 5. Combine Colors
    vec3 finalColor = baseColor.rgb + innerGlow + max(vec3(0.0), outerGlow) + scanlineGlow;

    // 6. Calculate Final Alpha
    float finalAlpha = max(baseColor.a, radialGlowAmount * GlowIntensity);
    finalAlpha = max(finalAlpha, scanlineAmount);

    // 7. Final Output
    fragColor = vec4(finalColor, finalAlpha) * ColorModulator;
}