#version 150

// MINECRAFT UNIFORMS
uniform sampler2D DiffuseSampler; // iChannel2: Input from the main game screen
uniform sampler2D FluidSampler;   // iChannel0: Input from the fluid simulation buffer
uniform sampler2D MeltingSampler; // iChannel1: Input from the melting effect buffer
uniform vec2 InSize;              // CORRECTED: Was OutSize

// INPUT/OUTPUT
in vec2 texCoord;
out vec4 fragColor;

// --- Shadertoy Port Helpers ---
vec4 camchan(vec2 coord) { return texture(DiffuseSampler, coord / InSize); } // Use InSize
vec4 tex(vec2 coord) { return texture(FluidSampler, coord / InSize); } // Use InSize
vec4 melting(vec2 coord) { return texture(MeltingSampler, coord / InSize); } // Use InSize

void main() {
    vec2 xy = texCoord * InSize; // Use InSize

    vec4 webcam = camchan(xy);
    vec4 melt = melting(xy);
    vec4 fluidData = tex(xy);

    float lumens = (webcam.r + webcam.g + webcam.b) * 0.333;
    vec4 blackwhite = vec4(1.0, 0.9, 0.01, 2.0);

    vec4 shimmer = sin(fluidData.w * blackwhite);

    if (lumens < 0.95) {
        fragColor = melt + webcam + shimmer;
    } else {
        fragColor = webcam + shimmer;
    }
}