#version 150

uniform sampler2D DiffuseSampler;     // vfield (vec2 in xy)
uniform sampler2D OriginalSampler;    // original color buffer
uniform sampler2D PrevSampler;        // previous frame feedback
uniform float CustomTime;
uniform float EffectIntensity;

in vec2 texCoord;
out vec4 FragColor;

#define DISP_SCALE 2.0
#define SAMPLES 64
#define SIGMOID_CONTRAST 12.0

vec3 contrast(vec3 x) {
    return 1.0 / (1.0 + exp(-SIGMOID_CONTRAST * (x - 0.5)));
}

vec2 normz(vec2 x) {
    return x == vec2(0.0) ? vec2(0.0) : normalize(x);
}

vec3 sampleWeights(float i) {
    return vec3(i * i, 46.6666*pow((1.0-i)*i,3.0), (1.0 - i) * (1.0 - i));
}

vec3 sampleDisp(vec2 uv, vec2 dispNorm, float disp) {
    vec3 col = vec3(0.0);
    const float SD = 1.0 / float(SAMPLES);
    float wl = 0.0;
    vec3 denom = vec3(0.0);
    for (int i = 0; i < SAMPLES; i++) {
        vec3 sw = sampleWeights(wl);
        denom += sw;
        col += sw * texture(OriginalSampler, uv + dispNorm * disp * wl).xyz;
        wl  += SD;
    }
    return col / denom;
}

void main() {
    vec3 originalColor = texture(OriginalSampler, texCoord).rgb;
    vec2 v = texture(DiffuseSampler, texCoord).xy * 2.0 - 1.0;
    float ld = length(v);
    vec2 ln = normz(v);

    vec3 dispColor = sampleDisp(texCoord, ln, DISP_SCALE * ld);
    dispColor = contrast(dispColor);

    // subtle feedback blend from previous frame
    vec3 prev = texture(PrevSampler, texCoord).rgb;
    vec3 combined = mix(originalColor, dispColor, 0.85);
    combined = mix(combined, prev, 0.15);

    vec3 finalColor = mix(originalColor, combined, clamp(EffectIntensity, 0.0, 1.0));
    FragColor = vec4(finalColor, 1.0);
}

