#version 150

uniform sampler2D DiffuseSampler;
uniform float CustomTime; // Now we're using this!
in vec2 texCoord;
out vec4 fragColor;

float smooth_step(float t) {
    return t * t * (3.0 - 2.0 * t);
}

void main() {
    vec4 tex = texture(DiffuseSampler, texCoord);
    float gray = (tex.r + tex.g + tex.b) * 0.333;

    vec3 color;

    // Animate the gradient by adding Time
    // We multiply by a smaller number (e.g., 5.0) to avoid a hard 'jump' when it loops
    float x = fract(gray + CustomTime * 0.01) * 5.0;

    // The rest of your logic works perfectly with the animated 'x'
    if (x < 1.0) {
        color = mix(vec3(1.0, 0.0, 0.0), vec3(1.0, 0.0, 1.0), smooth_step(x));
    } else if (x < 2.0) {
        color = mix(vec3(1.0, 0.0, 1.0), vec3(0.0, 0.0, 1.0), smooth_step(x - 1.0));
    } else if (x < 3.0) {
        color = mix(vec3(0.0, 0.0, 1.0), vec3(0.0, 1.0, 1.0), smooth_step(x - 2.0));
    } else if (x < 4.0) {
        color = mix(vec3(0.0, 1.0, 1.0), vec3(0.0, 1.0, 0.0), smooth_step(x - 3.0));
    } else { // x < 5.0
             color = mix(vec3(0.0, 1.0, 0.0), vec3(1.0, 1.0, 0.0), smooth_step(x - 4.0));
    }

    color = color * 0.75 + 0.25;
    fragColor = vec4(color, 1.0);
}