#version 150

// MINECRAFT UNIFORMS
uniform sampler2D DiffuseSampler; // iChannel2: Input from the main game screen
uniform sampler2D FluidSampler;   // iChannel0: Input from the fluid simulation buffer
uniform vec2 InSize;              // CORRECTED: Was OutSize

// INPUT/OUTPUT
in vec2 texCoord;
out vec4 fragColor;

// --- Shadertoy Port Helpers ---
vec4 webcam(vec2 coord) { return texture(DiffuseSampler, coord / InSize); } // Use InSize
vec4 tex(vec2 coord) { return texture(FluidSampler, coord / InSize); } // Use InSize

void main() {
    vec2 xy = texCoord * InSize; // Use InSize
    vec4 campix = webcam(xy);
    vec4 particle = tex(xy);

    vec4 a = tex(xy + vec2(1,0)) * campix.r;
    vec4 b = tex(xy + vec2(0,1)) + campix.g;
    vec4 c = tex(xy + vec2(-1,0)) + campix.b;
    vec4 d = tex(xy + vec2(0,-1)) + (campix.r * -0.0125);

    float presh = particle.z;

    if (presh < 0.2) {
        fragColor = tex(xy);
    } else {
        fragColor = campix * vec4(a.r, a.r, a.r, a.r);
    }
}