#version 150

uniform sampler2D FluidSampler;
uniform sampler2D DiffuseSampler;
in vec2 texCoord;
out vec4 fragColor;

void main() {
    vec4 data = texture(DiffuseSampler, texCoord);

    float R = (data.x > 0.1) ? 1.0 : 0.0;
    float G = (data.y > 0.1) ? 1.0 : 0.0;
    float B = (data.z > 0.1) ? 1.0 : 0.0; // Corrected from data.w

    fragColor = vec4(R, G, B, 1.0);
}