#version 150

uniform sampler2D DiffuseSampler;
uniform sampler2D OriginalSampler;
uniform float CustomTime;
uniform float EffectIntensity;

in vec2 texCoord;
out vec4 FragColor;

void main() {
    vec3 originalColor = texture(OriginalSampler, texCoord).rgb;
    vec3 distortedColor;
    vec4 heatmapTex = texture(DiffuseSampler, texCoord);

    if (heatmapTex.a < 1.0) {
        distortedColor = originalColor;
    } else {
        // --- EDGE FADE LOGIC ---
        // Calculate distance from the center (0.5, 0.5)
        float distFromCenter = distance(texCoord, vec2(0.5));
        // Create a smooth fade factor. Effect is full strength up to a distance of 0.35,
        // and fades to zero by the time it reaches a distance of 0.5.
        float edgeFade = 1.0 - smoothstep(0.35, 0.5, distFromCenter);

        vec2 offset = (heatmapTex.xy * 2.0 - 1.0);
        float d = 30.0;
        offset.x = cos(offset.x * d + CustomTime * 0.5);
        offset.y = sin(offset.y * d - CustomTime * 0.5);

        // Apply the fade to the offset and then add it to the texture coordinate.
        // No clamp or fract is needed here because the offset becomes zero at the edges.
        vec2 warpedUv = texCoord + offset * 0.05 * edgeFade;

        vec3 warpedColor = texture(DiffuseSampler, warpedUv).rgb;

        float gray = (warpedColor.r + warpedColor.g + warpedColor.b) * 0.333;
        float flicker = sin(CustomTime * 2.0 + gray * 20.0) * 0.5 + 0.5;

        if (flicker < 0.3) {
            distortedColor = originalColor;
        } else {
            distortedColor = warpedColor;
        }
    }

    vec3 finalColor = mix(originalColor, distortedColor, EffectIntensity);
    FragColor = vec4(finalColor, 1.0);
}