/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

class ApplyEnums {
    private ApplyEnums() {
    }

    static void applyTo(XmlPullParser xmlParser, PdbParser pdbParser, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Applying enums...");
        while (xmlParser.hasNext()) {
            monitor.checkCanceled();
            XmlElement elem = xmlParser.next();
            if (elem.isEnd() && elem.getName().equals("enums")) break;
            String name = SymbolUtilities.replaceInvalidChars((String)elem.getAttribute("name"), (boolean)false);
            int length = XmlUtilities.parseInt((String)elem.getAttribute("length"));
            EnumDataType enumdt = pdbParser.createEnum(name, length);
            while (!(!xmlParser.hasNext() || monitor.isCancelled() || (elem = xmlParser.next()).isEnd() && elem.getName().equals("enum"))) {
                ApplyEnums.applyEnumMember(enumdt, elem, monitor, log);
                xmlParser.next();
            }
            pdbParser.cacheDataType(name, (DataType)enumdt);
            pdbParser.getProgramDataTypeManager().resolve((DataType)enumdt, DataTypeConflictHandler.REPLACE_EMPTY_STRUCTS_OR_RENAME_AND_ADD_HANDLER);
        }
    }

    private static void applyEnumMember(EnumDataType enumdt, XmlElement memberElem, TaskMonitor monitor, MessageLog log) {
        String name = SymbolUtilities.replaceInvalidChars((String)memberElem.getAttribute("name"), (boolean)false);
        int memberValue = XmlUtilities.parseInt((String)memberElem.getAttribute("value"));
        try {
            enumdt.add(name, (long)memberValue);
        }
        catch (Exception e) {
            log.appendMsg("PDB", "Enum " + enumdt.getName() + ": " + e.getMessage());
        }
    }
}

