/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver.ui;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.event.mouse.GMouseListenerAdapter;
import docking.options.editor.ButtonPanelFactory;
import docking.widgets.OptionDialog;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GComboBox;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import docking.widgets.textfield.HexOrDecimalInput;
import docking.widgets.textfield.HintTextField;
import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbIdentifiers;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorControl;
import ghidra.framework.preferences.Preferences;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.IOCancelledException;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.PairLayout;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pdb.PdbPlugin;
import pdb.symbolserver.FindOption;
import pdb.symbolserver.SameDirSymbolStore;
import pdb.symbolserver.SymbolFileInfo;
import pdb.symbolserver.SymbolFileLocation;
import pdb.symbolserver.SymbolServer;
import pdb.symbolserver.SymbolServerInstanceCreatorContext;
import pdb.symbolserver.SymbolServerInstanceCreatorRegistry;
import pdb.symbolserver.SymbolServerService;
import pdb.symbolserver.SymbolStore;
import pdb.symbolserver.ui.ConfigPdbDialog;
import pdb.symbolserver.ui.SymbolFilePanel;
import pdb.symbolserver.ui.SymbolFileRow;
import pdb.symbolserver.ui.SymbolServerPanel;
import resources.Icons;
import resources.ResourceManager;

public class LoadPdbDialog
extends DialogComponentProvider {
    private static final String LAST_PDBFILE_PREFERENCE_KEY = "Pdb.LastFile";
    static final Icon MATCH_OK_ICON = ResourceManager.loadImage((String)"images/checkmark_green.gif", (int)16, (int)16);
    static final Icon MATCH_BAD_ICON = ResourceManager.loadImage((String)"images/emblem-important.png", (int)16, (int)16);
    public static final GhidraFileFilter PDB_FILES_FILTER = ExtensionFileFilter.forExtensions((String)"Microsoft Program Databases", (String[])new String[]{"pdb", "pd_", "pdb.xml"});
    private static final SymbolFileInfo UNKNOWN_SYMFILE = LoadPdbDialog.makeUnknownSymbolFileInstance("");
    private SymbolFileLocation selectedSymbolFile;
    private SymbolServerService symbolServerService;
    private SymbolServerInstanceCreatorContext symbolServerInstanceCreatorContext;
    private SymbolFileInfo programSymbolFileInfo;
    private List<Supplier<StatusText>> statusTextSuppliers = new ArrayList<Supplier<StatusText>>();
    private Set<FindOption> lastSearchOptions;
    private boolean searchCanceled;
    private boolean hasShownAdvanced;
    private Program program;
    private SymbolFilePanel symbolFilePanel;
    private JTextField programNameTextField;
    private JTextField pdbPathTextField;
    private GCheckBox overridePdbPathCheckBox;
    private JTextField pdbUniqueIdTextField;
    private GCheckBox overridePdbUniqueIdCheckBox;
    private HexOrDecimalInput pdbAgeTextField;
    private GCheckBox overridePdbAgeCheckBox;
    private HintTextField pdbLocationTextField;
    private GIconLabel exactMatchIconLabel;
    private JButton configButton;
    private JToggleButton advancedToggleButton;
    private GhidraFileChooser chooser;
    private JButton choosePdbLocationButton;
    private JButton loadPdbButton;
    private JPanel pdbLocationPanel;
    private JPanel programPdbPanel;
    private JComponent workComp;
    private JPanel parserOptionsPanel;
    private JRadioButton universalParserButton;
    private JRadioButton msdiaParserButton;
    private GComboBox<PdbApplicatorControl> applicatorControlCombo;

    public static LoadPdbResults choosePdbForProgram(Program program) {
        LoadPdbDialog choosePdbDlg = new LoadPdbDialog(program);
        DockingWindowManager.showDialog((DialogComponentProvider)choosePdbDlg);
        File pdbFile = choosePdbDlg.getLocalSymbolFile(choosePdbDlg.selectedSymbolFile);
        if (pdbFile == null) {
            return null;
        }
        LoadPdbResults results = new LoadPdbResults();
        results.pdbFile = pdbFile;
        results.control = (PdbApplicatorControl)((Object)choosePdbDlg.applicatorControlCombo.getSelectedItem());
        results.useMsDiaParser = choosePdbDlg.msdiaParserButton.isSelected();
        return results;
    }

    public LoadPdbDialog(Program program) {
        super("Load PDB for " + program.getName(), true, true, true, true);
        this.setRememberSize(false);
        this.program = program;
        this.programSymbolFileInfo = Objects.requireNonNullElse(SymbolFileInfo.fromProgramInfo(program), UNKNOWN_SYMFILE);
        this.updateSymbolServerServiceInstanceFromPreferences();
        this.build();
    }

    private void updateSymbolServerServiceInstanceFromPreferences() {
        this.symbolServerInstanceCreatorContext = SymbolServerInstanceCreatorRegistry.getInstance().getContext(this.program);
        this.symbolServerService = PdbPlugin.getSymbolServerService(this.symbolServerInstanceCreatorContext);
    }

    protected void dialogShown() {
        this.cancelButton.requestFocusInWindow();
        if (this.getCurrentSymbolFileInfo() != null) {
            this.searchForPdbs(false);
        }
    }

    protected void cancelCallback() {
        this.selectedSymbolFile = null;
        this.close();
    }

    public void setSearchOptions(Set<FindOption> options) {
        this.symbolFilePanel.setFindOptions(options);
    }

    private void setSelectedPdbFile(SymbolFileLocation symbolFileLocation) {
        this.selectedSymbolFile = symbolFileLocation;
        this.setPdbLocationValue(symbolFileLocation, this.getLocalSymbolFile(symbolFileLocation));
    }

    public void setSearchResults(List<SymbolFileLocation> results, Set<FindOption> findOptions) {
        this.lastSearchOptions = findOptions;
        this.symbolFilePanel.getTableModel().setSearchResults(this.programSymbolFileInfo, results);
    }

    public void selectRowByLocation(SymbolFileLocation symbolFileLocation) {
        for (int i = 0; i < this.symbolFilePanel.getTableModel().getModelData().size(); ++i) {
            SymbolFileRow symbolFileRow = this.symbolFilePanel.getTableModel().getModelData().get(i);
            if (!symbolFileRow.getLocation().equals(symbolFileLocation)) continue;
            this.symbolFilePanel.getTable().selectRow(i);
            return;
        }
        this.symbolFilePanel.getTable().clearSelection();
    }

    private StatusText getSelectedPdbNoticeText() {
        if (this.selectedSymbolFile == null) {
            return null;
        }
        if (this.selectedSymbolFile.getFileInfo() == null) {
            return new StatusText("Unable to read Pdb information", MessageType.ERROR, false);
        }
        return !this.selectedSymbolFile.isExactMatch(this.programSymbolFileInfo) ? new StatusText("WARNING: Selected PDB is not an exact match!", MessageType.WARNING, false) : null;
    }

    private String getSymbolFileToolText(SymbolFileLocation symbolFileLocation) {
        return symbolFileLocation != null ? String.format("<html><table><tr><td>PDB Name:</td><td><b>%s</b></td></tr><tr><td>Path:</td><td><b>%s</b></td></tr><tr><td>GUID/ID:</td><td><b>%s</b></td></tr><tr><td>Age:</td><td><b>%x</b></td></tr><tr><td>Is Exact Match:</td><td><b>%b</b></td</tr></table>", HTMLUtilities.escapeHTML((String)symbolFileLocation.getFileInfo().getName()), HTMLUtilities.escapeHTML((String)symbolFileLocation.getLocationStr()), symbolFileLocation.getFileInfo().getUniqueName(), symbolFileLocation.getFileInfo().getIdentifiers().getAge(), symbolFileLocation.getFileInfo().isExactMatch(this.programSymbolFileInfo)) : null;
    }

    private void updateButtonEnablement() {
        boolean hasLocation = this.selectedSymbolFile != null;
        boolean hasGoodService = this.symbolServerService.isValid();
        boolean isSearchable = this.getCurrentSymbolFileInfo() != null;
        this.loadPdbButton.setEnabled(hasLocation);
        this.configButton.setIcon(hasGoodService ? null : MATCH_BAD_ICON);
        this.configButton.setToolTipText(hasGoodService ? null : "Missing configuration");
        this.symbolFilePanel.setEnablement(hasGoodService, isSearchable);
    }

    private SymbolFileInfo getCurrentSymbolFileInfo() {
        String pdbPath = this.pdbPathTextField.getText();
        String uid = this.pdbUniqueIdTextField.getText();
        int age = this.pdbAgeTextField.getIntValue();
        return SymbolFileInfo.fromValues(pdbPath, uid, age);
    }

    private void searchForPdbs(boolean allowRemote) {
        if (this.pdbAgeTextField.getText().isBlank() || this.pdbAgeTextField.getValue() > 0xFFFFFFFFL) {
            Msg.showWarn((Object)((Object)this), null, (String)"Bad PDB Age", (Object)"Invalid PDB Age value");
            return;
        }
        SymbolFileInfo symbolFileInfo = this.getCurrentSymbolFileInfo();
        if (symbolFileInfo == null) {
            Msg.showWarn((Object)((Object)this), null, (String)"Bad PDB Values", (Object)"Invalid PDB Path / GUID / UID value");
            return;
        }
        Set<FindOption> findOptions = this.symbolFilePanel.getFindOptions();
        if (allowRemote) {
            findOptions.add(FindOption.ALLOW_REMOTE);
        }
        this.executeMonitoredRunnable("Search for PDBs", true, true, 0, monitor -> {
            try {
                this.searchCanceled = false;
                List<SymbolFileLocation> results = this.symbolServerService.find(symbolFileInfo, findOptions, monitor);
                Swing.runLater(() -> {
                    this.setSearchResults(results, findOptions);
                    if (!results.isEmpty()) {
                        this.selectRowByLocation((SymbolFileLocation)results.get(0));
                    }
                    this.updateStatusText();
                    this.updateButtonEnablement();
                    this.updateParserOptionEnablement(true);
                });
            }
            catch (CancelledException e1) {
                this.searchCanceled = true;
                Swing.runLater(() -> this.updateStatusText());
            }
        });
    }

    private void build() {
        this.buildSymbolFilePanel();
        this.buildPdbLocationPanel();
        this.buildProgramPdbPanel();
        this.buildParserOptionsPanel();
        this.setHelpLocation(new HelpLocation("Pdb", "Load PDB File"));
        this.addStatusTextSupplier(() -> this.lastSearchOptions != null && this.advancedToggleButton.isSelected() ? SymbolServerPanel.getSymbolServerWarnings(this.symbolServerService.getSymbolServers()) : null);
        this.addStatusTextSupplier(this::getSelectedPdbNoticeText);
        this.addStatusTextSupplier(this::getAllowRemoteWarning);
        this.addStatusTextSupplier(this::getFoundCountInfo);
        this.addButtons();
        this.layoutSimple();
        this.updateStatusText();
        this.updateButtonEnablement();
    }

    private void buildSymbolFilePanel() {
        this.symbolFilePanel = new SymbolFilePanel(this::searchForPdbs);
        this.symbolFilePanel.getTable().getSelectionModel().addListSelectionListener(e -> this.updateSelectedRow());
        this.symbolFilePanel.getTable().addMouseListener((MouseListener)new GMouseListenerAdapter(){

            public void doubleClickTriggered(MouseEvent e) {
                if (LoadPdbDialog.this.loadPdbButton.isEnabled()) {
                    e.consume();
                    LoadPdbDialog.this.loadPdbButton.doClick();
                }
            }
        });
    }

    private void updateSelectedRow() {
        SymbolFileRow row = this.symbolFilePanel.getSelectedRow();
        this.setSelectedPdbFile(row != null ? row.getLocation() : null);
        this.updateStatusText();
        this.updateButtonEnablement();
        this.updateParserOptionEnablement(true);
    }

    private JPanel buildProgramPdbPanel() {
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                LoadPdbDialog.this.updateButtonEnablement();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                LoadPdbDialog.this.updateButtonEnablement();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LoadPdbDialog.this.updateButtonEnablement();
            }
        };
        this.programNameTextField = new BetterNonEditableTextField(20);
        this.programNameTextField.setEditable(false);
        this.programNameTextField.setText(this.program.getName());
        this.pdbPathTextField = new BetterNonEditableTextField(20, "Missing", Color.red);
        this.pdbPathTextField.setEditable(false);
        this.pdbPathTextField.setText(this.programSymbolFileInfo.getPath());
        this.pdbPathTextField.getDocument().addDocumentListener(docListener);
        this.overridePdbPathCheckBox = new GCheckBox();
        this.overridePdbPathCheckBox.setVisible(false);
        this.overridePdbPathCheckBox.setToolTipText("Override PDB name (when searching).");
        this.overridePdbPathCheckBox.addItemListener(e -> {
            this.pdbPathTextField.setEditable(this.overridePdbPathCheckBox.isSelected());
            if (this.overridePdbPathCheckBox.isSelected()) {
                this.pdbPathTextField.requestFocusInWindow();
            } else {
                this.pdbPathTextField.setText(this.programSymbolFileInfo.getPath());
            }
        });
        DockingWindowManager.getHelpService().registerHelp((Object)this.overridePdbPathCheckBox, new HelpLocation("Pdb", "PDB_Search_Search_Options"));
        this.pdbUniqueIdTextField = new BetterNonEditableTextField(36, "Missing", Color.red);
        this.pdbUniqueIdTextField.setEditable(false);
        this.pdbUniqueIdTextField.setText(this.programSymbolFileInfo.getUniqifierString());
        this.pdbUniqueIdTextField.setToolTipText("<html>PDB GUID - 32 hexadecimal characters:<br>&nbsp;&nbsp;<b>'012345678-0123-0123-0123-0123456789ABC'</b> (with or without dashes) or<br>PDB Signature ID - 8 hexadecimal characters:<br>&nbsp;&nbsp;<b>'11223344'</b>");
        this.pdbUniqueIdTextField.getDocument().addDocumentListener(docListener);
        this.overridePdbUniqueIdCheckBox = new GCheckBox();
        this.overridePdbUniqueIdCheckBox.setVisible(false);
        this.overridePdbUniqueIdCheckBox.setToolTipText("Override PDB Unique ID (when searching).");
        this.overridePdbUniqueIdCheckBox.addItemListener(e -> {
            this.pdbUniqueIdTextField.setEditable(this.overridePdbUniqueIdCheckBox.isSelected());
            if (this.overridePdbUniqueIdCheckBox.isSelected()) {
                this.pdbUniqueIdTextField.requestFocusInWindow();
            } else {
                this.pdbUniqueIdTextField.setText(this.programSymbolFileInfo.getUniqifierString());
            }
        });
        DockingWindowManager.getHelpService().registerHelp((Object)this.overridePdbUniqueIdCheckBox, new HelpLocation("Pdb", "PDB_Search_Search_Options"));
        this.pdbAgeTextField = new BetterNonEditableHexTextField(8);
        this.pdbAgeTextField.setAllowNegative(false);
        this.pdbAgeTextField.setHexMode();
        this.pdbAgeTextField.setValue(this.programSymbolFileInfo.getIdentifiers().getAge());
        this.pdbAgeTextField.setEditable(false);
        this.pdbAgeTextField.getDocument().addDocumentListener(docListener);
        this.overridePdbAgeCheckBox = new GCheckBox();
        this.overridePdbAgeCheckBox.setVisible(false);
        this.overridePdbAgeCheckBox.setToolTipText("Override PDB age (when searching).");
        this.overridePdbAgeCheckBox.addItemListener(e -> {
            this.pdbAgeTextField.setEditable(this.overridePdbAgeCheckBox.isSelected());
            if (this.overridePdbAgeCheckBox.isSelected()) {
                this.pdbAgeTextField.requestFocus();
            } else {
                this.pdbAgeTextField.setValue(this.programSymbolFileInfo.getIdentifiers().getAge());
            }
        });
        DockingWindowManager.getHelpService().registerHelp((Object)this.overridePdbAgeCheckBox, new HelpLocation("Pdb", "PDB_Search_Search_Options"));
        this.programPdbPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        this.programPdbPanel.setBorder(BorderFactory.createTitledBorder("Program PDB Information"));
        this.programPdbPanel.add((Component)new GLabel("Program:", 4));
        this.programPdbPanel.add(this.programNameTextField);
        this.programPdbPanel.add(LoadPdbDialog.join(null, (JComponent)new GLabel("PDB Name:", 4), (JComponent)this.overridePdbPathCheckBox));
        this.programPdbPanel.add(this.pdbPathTextField);
        this.programPdbPanel.add(LoadPdbDialog.join(null, (JComponent)new GLabel("PDB Unique ID:", 4), (JComponent)this.overridePdbUniqueIdCheckBox));
        this.programPdbPanel.add(this.pdbUniqueIdTextField);
        this.programPdbPanel.add(LoadPdbDialog.join(null, (JComponent)new GLabel("PDB Age:", 4), (JComponent)this.overridePdbAgeCheckBox));
        this.programPdbPanel.add(LoadPdbDialog.join((JComponent)this.pdbAgeTextField, new JPanel(), null));
        return this.programPdbPanel;
    }

    private JPanel buildPdbLocationPanel() {
        this.pdbLocationTextField = new HintTextField("Browse [...] for PDB file or use 'Advanced'");
        this.pdbLocationTextField.setEditable(false);
        this.choosePdbLocationButton = ButtonPanelFactory.createButton((int)2);
        this.choosePdbLocationButton.addActionListener(e -> this.choosePdbFile());
        this.exactMatchIconLabel = new GIconLabel((Icon)Icons.EMPTY_ICON);
        this.pdbLocationPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        this.pdbLocationPanel.setBorder(BorderFactory.createTitledBorder("PDB Location"));
        this.pdbLocationPanel.add((Component)new GLabel("PDB Location:", 4));
        this.pdbLocationPanel.add(LoadPdbDialog.join((JComponent)this.exactMatchIconLabel, (JComponent)this.pdbLocationTextField, this.choosePdbLocationButton));
        return this.pdbLocationPanel;
    }

    private void updateParserOptionEnablement(boolean trySetUniversal) {
        if (trySetUniversal) {
            this.universalParserButton.setSelected(true);
            this.msdiaParserButton.setSelected(false);
        }
        boolean isXML = this.selectedSymbolFile != null && this.selectedSymbolFile.getPath().toLowerCase().endsWith(".pdb.xml");
        boolean isWindows = PdbParser.onWindows;
        this.msdiaParserButton.setEnabled(isXML || isWindows);
        if (isXML) {
            this.msdiaParserButton.setSelected(true);
        }
        if (this.msdiaParserButton.isSelected() && !this.msdiaParserButton.isEnabled()) {
            this.msdiaParserButton.setSelected(false);
        }
        if (!isWindows && !isXML) {
            this.universalParserButton.setSelected(true);
        }
        this.universalParserButton.setEnabled(!isXML);
        if (this.universalParserButton.isSelected() && !this.universalParserButton.isEnabled()) {
            this.universalParserButton.setSelected(false);
        }
        this.applicatorControlCombo.setEnabled(this.universalParserButton.isSelected());
        if (!this.applicatorControlCombo.isEnabled()) {
            this.applicatorControlCombo.setSelectedItem((Object)PdbApplicatorControl.ALL);
        }
    }

    private JPanel buildParserOptionsPanel() {
        ActionListener l = e -> this.updateParserOptionEnablement(false);
        this.universalParserButton = new JRadioButton("Universal");
        this.universalParserButton.setToolTipText("Platform-independent PDB analyzer (No PDB.XML support).");
        this.msdiaParserButton = new JRadioButton("MSDIA");
        this.msdiaParserButton.setToolTipText("<html>Legacy PDB Analyzer.<br>Requires MS DIA-SDK for raw PDB processing (Windows only), or preprocessed PDB.XML file.");
        this.universalParserButton.setSelected(true);
        this.universalParserButton.addActionListener(l);
        this.msdiaParserButton.addActionListener(l);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.msdiaParserButton);
        buttonGroup.add(this.universalParserButton);
        JPanel radioButtons = new JPanel(new FlowLayout(0));
        radioButtons.add(this.universalParserButton);
        radioButtons.add(this.msdiaParserButton);
        this.applicatorControlCombo = new GComboBox((Object[])PdbApplicatorControl.values());
        this.applicatorControlCombo.setToolTipText("Selects which subsets of information to parse.");
        this.applicatorControlCombo.setSelectedItem((Object)PdbApplicatorControl.ALL);
        this.parserOptionsPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        this.parserOptionsPanel.setBorder(BorderFactory.createTitledBorder("PDB Parser"));
        DockingWindowManager.getHelpService().registerHelp((Object)this.parserOptionsPanel, new HelpLocation("Pdb", "PDB Parser Panel"));
        this.parserOptionsPanel.add((Component)new GLabel("Parser:"));
        this.parserOptionsPanel.add(radioButtons);
        this.parserOptionsPanel.add((Component)new GLabel("Control:"));
        this.parserOptionsPanel.add((Component)this.applicatorControlCombo);
        return this.parserOptionsPanel;
    }

    private void addButtons() {
        this.loadPdbButton = new JButton("Load");
        this.loadPdbButton.setName("Load");
        this.loadPdbButton.addActionListener(e -> {
            if (this.selectedSymbolFile == null || !this.selectedSymbolFile.isExactMatch(this.programSymbolFileInfo) && OptionDialog.showYesNoDialog((Component)this.loadPdbButton, (String)"Mismatched Pdb File Warning", (String)"<html>The selected file is not an exact match for the current program.<br>Note: <b>Invalid disassembly may be produced!</b><br>Continue anyway?") != 1) {
                return;
            }
            this.executeMonitoredRunnable("Prepare Selected Symbol File", true, true, 0, this::prepareSelectedSymbolFileAndClose);
        });
        this.addButton(this.loadPdbButton);
        this.addCancelButton();
        this.setDefaultButton(this.cancelButton);
        this.configButton = new JButton("Config...");
        this.configButton.addActionListener(e -> {
            if (ConfigPdbDialog.showSymbolServerConfig()) {
                this.updateSymbolServerServiceInstanceFromPreferences();
                this.updateButtonEnablement();
                this.updateStatusText();
                this.searchForPdbs(false);
            }
        });
        this.addButton(this.configButton);
        this.advancedToggleButton = new JToggleButton("Advanced >>");
        this.advancedToggleButton.addActionListener(e -> this.toggleAdvancedSearch());
        this.buttonPanel.add(this.advancedToggleButton);
    }

    private void prepareSelectedSymbolFileAndClose(TaskMonitor monitor) {
        try {
            if (this.selectedSymbolFile != null) {
                this.selectedSymbolFile = this.symbolServerService.getLocalSymbolFileLocation(this.selectedSymbolFile, monitor);
            }
            Swing.runLater(() -> this.close());
            return;
        }
        catch (CancelledException | IOCancelledException ce) {
            this.setStatusText("Operation cancelled");
            monitor.clearCanceled();
        }
        catch (IOException ioe) {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Error Getting Symbol File", (Object)ioe);
        }
    }

    private StatusText getAllowRemoteWarning() {
        int remoteSymbolServerCount = this.symbolServerService.getRemoteSymbolServerCount();
        return this.lastSearchOptions != null && this.advancedToggleButton.isSelected() && remoteSymbolServerCount != 0 && !this.lastSearchOptions.contains((Object)FindOption.ALLOW_REMOTE) ? new StatusText("Remote servers were excluded.  Use \"Search All\" button to also search remote servers.", MessageType.INFO, false) : null;
    }

    private StatusText getFoundCountInfo() {
        if (this.advancedToggleButton.isSelected()) {
            if (this.searchCanceled) {
                return new StatusText("Search canceled", MessageType.INFO, false);
            }
            if (this.lastSearchOptions != null) {
                int foundCount;
                return new StatusText("Found " + foundCount + " file" + ((foundCount = this.symbolFilePanel.getTableModel().getModelData().size()) != 1 ? "s" : ""), MessageType.INFO, false);
            }
        }
        return null;
    }

    private void toggleAdvancedSearch() {
        boolean isAdvanced = this.advancedToggleButton.isSelected();
        this.advancedToggleButton.setText("Advanced " + (isAdvanced ? "<<" : ">>"));
        this.overridePdbAgeCheckBox.setVisible(isAdvanced);
        this.overridePdbPathCheckBox.setVisible(isAdvanced);
        this.overridePdbUniqueIdCheckBox.setVisible(isAdvanced);
        if (isAdvanced) {
            this.layoutAdvanced();
        } else {
            this.layoutSimple();
        }
        this.updateStatusText();
        this.updateButtonEnablement();
        this.updateParserOptionEnablement(false);
        if (isAdvanced && !this.hasShownAdvanced) {
            this.hasShownAdvanced = true;
            this.repack();
        }
    }

    private void layoutSimple() {
        Box box = Box.createVerticalBox();
        box.add(this.programPdbPanel);
        box.add(this.pdbLocationPanel);
        box.add(this.parserOptionsPanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "North");
        this.overrideWorkPanel(panel);
    }

    private void overrideWorkPanel(JComponent newWorkComp) {
        if (this.workComp != null && this.workComp.getParent() != null) {
            this.workComp.getParent().remove(this.workComp);
        }
        this.workComp = newWorkComp;
        this.addWorkPanel(newWorkComp);
    }

    private void layoutAdvanced() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.programPdbPanel, "North");
        mainPanel.add((Component)this.symbolFilePanel, "Center");
        mainPanel.add((Component)this.parserOptionsPanel, "South");
        this.overrideWorkPanel(mainPanel);
    }

    private void choosePdbFile() {
        File file = this.getChooser().getSelectedFile();
        if (file != null && file.isFile()) {
            Preferences.setProperty((String)LAST_PDBFILE_PREFERENCE_KEY, (String)file.getPath());
            this.executeMonitoredRunnable("Get PDB Info", true, true, 0, monitor -> {
                SymbolFileInfo pdbSymbolFileInfo = SymbolFileInfo.fromFile(file, monitor);
                if (pdbSymbolFileInfo == null) {
                    pdbSymbolFileInfo = LoadPdbDialog.makeUnknownSymbolFileInstance(file.getName());
                }
                SymbolFileLocation symbolFileLocation = SameDirSymbolStore.createManuallySelectedSymbolFileLocation(file, pdbSymbolFileInfo);
                Swing.runLater(() -> {
                    this.setSearchResults(List.of(symbolFileLocation), null);
                    this.setSelectedPdbFile(symbolFileLocation);
                    this.setPdbLocationValue(symbolFileLocation, file);
                    this.selectRowByLocation(symbolFileLocation);
                    this.updateStatusText();
                    this.updateButtonEnablement();
                    this.updateParserOptionEnablement(true);
                });
            });
        }
    }

    private void setPdbLocationValue(SymbolFileLocation symbolFileLocation, File file) {
        boolean isExactMatch = symbolFileLocation != null ? symbolFileLocation.isExactMatch(this.programSymbolFileInfo) : false;
        this.pdbLocationTextField.setText(file != null ? file.getPath() : "");
        this.pdbLocationTextField.setToolTipText(this.getSymbolFileToolText(symbolFileLocation));
        this.exactMatchIconLabel.setIcon(file == null ? null : (isExactMatch ? MATCH_OK_ICON : MATCH_BAD_ICON));
        this.exactMatchIconLabel.setToolTipText(file == null ? null : (isExactMatch ? "Exact match" : "Not exact match"));
    }

    private GhidraFileChooser getChooser() {
        if (this.chooser == null) {
            this.chooser = new GhidraFileChooser((Component)this.getComponent());
            this.chooser.addFileFilter(PDB_FILES_FILTER);
            this.chooser.setMultiSelectionEnabled(false);
            this.chooser.setApproveButtonText("Choose");
            this.chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
            this.chooser.setTitle("Select PDB");
            String lastFile = Preferences.getProperty((String)LAST_PDBFILE_PREFERENCE_KEY);
            if (lastFile != null) {
                this.chooser.setSelectedFile(new File(lastFile));
            }
        }
        return this.chooser;
    }

    private void addStatusTextSupplier(Supplier<StatusText> supplier) {
        this.statusTextSuppliers.remove(supplier);
        this.statusTextSuppliers.add(supplier);
    }

    private void updateStatusText() {
        StringBuilder sb = new StringBuilder();
        boolean alert = false;
        MessageType mt = MessageType.INFO;
        for (Supplier<StatusText> supplier : this.statusTextSuppliers) {
            StatusText statusText = supplier.get();
            if (statusText == null || statusText.message == null || statusText.message.isEmpty()) continue;
            if (sb.length() != 0) {
                sb.append("<br>");
            }
            sb.append(HTMLUtilities.colorString((Color)this.getStatusColor(statusText.messageType), (String)statusText.message));
            alert |= statusText.alert;
            if (mt.ordinal() >= statusText.messageType.ordinal()) continue;
            mt = statusText.messageType;
        }
        if (sb.length() != 0) {
            this.setStatusText("<html>" + sb.toString(), mt, alert);
        } else {
            this.clearStatusText();
        }
    }

    private File getLocalSymbolFile(SymbolFileLocation symbolFileLocation) {
        if (symbolFileLocation == null) {
            return null;
        }
        SymbolServer symbolServer = symbolFileLocation.getSymbolServer();
        if (!(symbolServer instanceof SymbolStore)) {
            return null;
        }
        SymbolStore symbolStore = (SymbolStore)symbolServer;
        File file = symbolStore.getFile(symbolFileLocation.getPath());
        return SymbolStore.isCompressedFilename(file.getName()) ? null : file;
    }

    private void executeMonitoredRunnable(String taskTitle, boolean canCancel, boolean hasProgress, int delay, final MonitoredRunnable runnable) {
        Task task = new Task(taskTitle, canCancel, hasProgress, false){

            public void run(TaskMonitor monitor) throws CancelledException {
                runnable.monitoredRun(monitor);
            }
        };
        this.executeProgressTask(task, delay);
    }

    private static SymbolFileInfo makeUnknownSymbolFileInstance(String path) {
        return SymbolFileInfo.fromPdbIdentifiers(path, new PdbIdentifiers(0, 0, 0, null, null));
    }

    static JPanel join(JComponent left, JComponent main, JComponent right) {
        JPanel panel = new JPanel(new BorderLayout());
        if (left != null) {
            panel.add((Component)left, "West");
        }
        panel.add((Component)main, "Center");
        if (right != null) {
            panel.add((Component)right, "East");
        }
        return panel;
    }

    static class BetterNonEditableHexTextField
    extends HexOrDecimalInput {
        BetterNonEditableHexTextField(int columns) {
            super(columns);
        }

        public Color getBackground() {
            Container parent = this.getParent();
            if (parent != null && !this.isEditable()) {
                Color bg = parent.getBackground();
                return new Color(bg.getRGB());
            }
            return super.getBackground();
        }
    }

    static class BetterNonEditableTextField
    extends JTextField {
        private String hint;
        private Color hintColor;

        BetterNonEditableTextField(int columns) {
            this(columns, null, null);
        }

        public BetterNonEditableTextField(int columns, String hint, Color hintColor) {
            super(columns);
            this.hint = hint;
            this.hintColor = hintColor;
        }

        @Override
        public Color getBackground() {
            Container parent = this.getParent();
            if (parent != null && !this.isEditable()) {
                Color bg = parent.getBackground();
                return new Color(bg.getRGB());
            }
            return super.getBackground();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!this.getText().isEmpty() || this.hint == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.hintColor != null ? this.hintColor : Color.LIGHT_GRAY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            int x = 10;
            int y = size.height - insets.bottom - 1;
            g2.drawString(this.hint, x, y);
        }
    }

    static class StatusText {
        public String message;
        public MessageType messageType;
        public boolean alert;

        public StatusText(String message, MessageType messageType, boolean alert) {
            this.message = message;
            this.messageType = messageType;
            this.alert = alert;
        }
    }

    public static class LoadPdbResults {
        public File pdbFile;
        public PdbApplicatorControl control;
        public boolean useMsDiaParser;
    }
}

