/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver.ui;

import docking.widgets.table.AbstractDynamicTableColumnStub;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import pdb.symbolserver.SymbolFileInfo;
import pdb.symbolserver.SymbolFileLocation;
import pdb.symbolserver.ui.LoadPdbDialog;
import pdb.symbolserver.ui.SymbolFileRow;

class SymbolFileTableModel
extends GDynamicColumnTableModel<SymbolFileRow, List<SymbolFileRow>> {
    private List<SymbolFileRow> rows = new ArrayList<SymbolFileRow>();

    SymbolFileTableModel() {
        super((ServiceProvider)new ServiceProviderStub());
        this.setDefaultTableSortState(null);
    }

    void setRows(List<SymbolFileRow> rows) {
        this.rows = rows;
        this.fireTableDataChanged();
    }

    void setSearchResults(SymbolFileInfo symbolFileInfo, List<SymbolFileLocation> results) {
        ArrayList<SymbolFileRow> newRows = new ArrayList<SymbolFileRow>();
        for (SymbolFileLocation symbolFileLocation : results) {
            newRows.add(new SymbolFileRow(symbolFileLocation, symbolFileLocation.isExactMatch(symbolFileInfo)));
        }
        this.rows = newRows;
        this.fireTableDataChanged();
    }

    public String getName() {
        return "Symbol Files";
    }

    public List<SymbolFileRow> getModelData() {
        return this.rows;
    }

    public List<SymbolFileRow> getDataSource() {
        return this.rows;
    }

    protected TableColumnDescriptor<SymbolFileRow> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new PdbExactMatchColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new PdbFileNameColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new PdbFilePathColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new GuidColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new PdbAgeColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new PdbVersionColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new PdbFileStatusColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new PdbFileLocationColumn());
        return descriptor;
    }

    private static class BooleanIconColumnRenderer
    extends AbstractGColumnRenderer<Boolean> {
        private Icon[] icons;
        private String[] toolTipStrings;

        BooleanIconColumnRenderer(Icon trueIcon, Icon falseIcon, Icon missingIcon, String trueTooltip, String falseTooltip, String missingTooltip) {
            this.icons = new Icon[]{missingIcon, falseIcon, trueIcon};
            this.toolTipStrings = new String[]{missingTooltip, falseTooltip, trueTooltip};
        }

        private int getValueOrdinal(GTableCellRenderingData data) {
            Boolean booleanValue = (Boolean)data.getValue();
            return booleanValue == null ? 0 : (booleanValue != false ? 2 : 1);
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            int ordinal = this.getValueOrdinal(data);
            renderer.setHorizontalAlignment(0);
            renderer.setText("");
            renderer.setIcon(this.icons[ordinal]);
            renderer.setToolTipText(this.toolTipStrings[ordinal]);
            return renderer;
        }

        public String getFilterString(Boolean booleanValue, Settings settings) {
            return booleanValue == null ? "" : booleanValue.toString();
        }
    }

    private class PdbFileLocationColumn
    extends AbstractDynamicTableColumnStub<SymbolFileRow, String> {
        private PdbFileLocationColumn() {
        }

        public String getValue(SymbolFileRow row, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return row.getLocation().getLocationStr();
        }

        public String getColumnName() {
            return "File Location";
        }
    }

    private class PdbFileStatusColumn
    extends AbstractDynamicTableColumnStub<SymbolFileRow, String> {
        private PdbFileStatusColumn() {
        }

        public String getValue(SymbolFileRow row, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return row.isAvailableLocal() ? "Local" : "Remote";
        }

        public String getColumnName() {
            return "PDB File Status";
        }

        public int getColumnPreferredWidth() {
            return 120;
        }
    }

    private class PdbAgeColumn
    extends AbstractDynamicTableColumnStub<SymbolFileRow, Integer> {
        private PdbAgeColumn() {
        }

        public Integer getValue(SymbolFileRow rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSymbolFileInfo().getIdentifiers().getAge();
        }

        public String getColumnName() {
            return "PDB Age";
        }

        public int getColumnPreferredWidth() {
            return 120;
        }
    }

    private class PdbVersionColumn
    extends AbstractDynamicTableColumnStub<SymbolFileRow, String> {
        private PdbVersionColumn() {
        }

        public String getValue(SymbolFileRow rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return Integer.toString(rowObject.getSymbolFileInfo().getIdentifiers().getVersion());
        }

        public String getColumnName() {
            return "PDB Version";
        }
    }

    private class GuidColumn
    extends AbstractDynamicTableColumnStub<SymbolFileRow, String> {
        private GuidColumn() {
        }

        public String getValue(SymbolFileRow rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSymbolFileInfo().getUniqueName();
        }

        public String getColumnName() {
            return "GUID / Signature";
        }

        public int getColumnPreferredWidth() {
            return 300;
        }
    }

    private class PdbFilePathColumn
    extends AbstractDynamicTableColumnStub<SymbolFileRow, String> {
        private PdbFilePathColumn() {
        }

        public String getValue(SymbolFileRow rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSymbolFileInfo().getPath();
        }

        public String getColumnName() {
            return "PDB Filepath";
        }
    }

    private class PdbFileNameColumn
    extends AbstractDynamicTableColumnStub<SymbolFileRow, String> {
        private PdbFileNameColumn() {
        }

        public String getValue(SymbolFileRow rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getSymbolFileInfo().getName();
        }

        public String getColumnName() {
            return "PDB Filename";
        }

        public int getColumnPreferredWidth() {
            return 200;
        }
    }

    private class PdbExactMatchColumn
    extends AbstractDynamicTableColumnStub<SymbolFileRow, Boolean> {
        BooleanIconColumnRenderer renderer = new BooleanIconColumnRenderer(LoadPdbDialog.MATCH_OK_ICON, LoadPdbDialog.MATCH_BAD_ICON, null, "Exact Match", "Not Exact Match", null);

        private PdbExactMatchColumn() {
        }

        public Boolean getValue(SymbolFileRow rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.isExactMatch();
        }

        public GColumnRenderer<Boolean> getColumnRenderer() {
            return this.renderer;
        }

        public String getColumnName() {
            return "Exact Match";
        }

        public String getColumnDisplayName(Settings settings) {
            return "";
        }
    }
}

